% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,GCxGC-method}
\title{Method plot}
\usage{
plot(Object, ...)

\S4method{plot}{GCxGC}(Object, ...)
}
\arguments{
\item{Object}{a GCxGC chromatogram, it could be a raw, or preprocessed
chromatogram}

\item{...}{Other parameters passes to \code{\link[graphics]{filled.contour}}
function.}
}
\description{
`plot` plot the bidimensional chromatogram as a
 filled contour plot
}
\details{
This plot function employs the built-in countour function. As
 mentioned in \insertCite{Reichenbach2004;textual}{RGCxGC}, interpolation
 is usedto display non-native GCxGC data.
}
\examples{

library(colorRamps)
chrom_name <-  system.file("extdata", "08GB.cdf", package = "RGCxGC")
chrom_2D <- read_chrom(chrom_name, 5L)
plot(chrom_2D, nlevels = 150, color.palette = matlab.like)

}
\references{
\insertAllCited{}
}
