/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import freak.module.searchspace.logictree.AtomicNode;
import freak.module.searchspace.logictree.Data;
import java.io.Serializable;

public class VariableInputNode
implements AtomicNode,
Serializable {
    private int inputNumber;
    private int numVars = 0;
    private String name;

    public VariableInputNode(int numVariables) {
        if (numVariables > 0) {
            this.inputNumber = Data.nextRandInt(numVariables);
            this.numVars = numVariables;
            this.name = Data.getVarName(this.inputNumber);
        } else {
            this.inputNumber = -1;
            this.numVars = 0;
        }
    }

    public VariableInputNode(int numVariables, int num) {
        if (numVariables > 0) {
            this.numVars = numVariables;
            this.inputNumber = num >= 0 && num < numVariables ? num : Data.nextRandInt(numVariables);
            this.name = Data.getVarName(this.inputNumber);
        } else {
            this.numVars = 0;
            this.inputNumber = -1;
        }
    }

    public int getValue(byte[] row) {
        if (this.inputNumber >= 0 && this.inputNumber < row.length) {
            return row[this.inputNumber];
        }
        return 0;
    }

    int getInputNumber() {
        return this.inputNumber;
    }

    void setInputNumber(int n) {
        if (n >= 0 && n < this.numVars) {
            this.inputNumber = n;
        }
    }

    void setRandomInputNumber() {
        this.inputNumber = Data.nextRandInt(this.numVars);
    }

    void setNumVars(int num) {
        if (num >= 0) {
            this.numVars = num;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VariableInputNode)) {
            return false;
        }
        return ((VariableInputNode)o).getInputNumber() == this.getInputNumber();
    }

    public String toString() {
        String rueckgabe = this.name;
        return rueckgabe;
    }

    public Object clone() {
        VariableInputNode in = new VariableInputNode(this.numVars, this.inputNumber);
        return in;
    }
}

