/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.FreakClassComparator;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import freak.core.util.StreamCopy;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Batch
implements Serializable {
    private Map configurationObjects = new HashMap();
    private int runs = 100;
    private boolean started = false;
    private boolean finished = false;

    public void putConfiguration(Configurable configurableObject, Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configurationObjects.put(configurableObject, configuration);
    }

    public Configuration getConfiguration(Configurable configurableObject) {
        Configuration result = (Configuration)this.configurationObjects.get(configurableObject);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public int getRuns() {
        return this.runs;
    }

    public void setRuns(int runs) {
        if (runs < 1) {
            throw new IllegalArgumentException();
        }
        this.runs = runs;
    }

    public void applyAllConfigurations() {
        this.applyAllConfigurations(this.configurationObjects);
    }

    private void applyAllConfigurations(Map configurationObjects) {
        Set set = configurationObjects.keySet();
        Module[] modules = set.toArray(new Module[set.size()]);
        Arrays.sort(modules, new FreakClassComparator());
        int i = 0;
        while (i < modules.length) {
            Configurable configurable = (Configurable)modules[i];
            Configuration configuration = (Configuration)configurationObjects.get(configurable);
            configurable.setConfiguration(configuration);
            ++i;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean b) {
        this.finished = b;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean b) {
        this.started = b;
    }

    public Batch copy() {
        Batch result = new Batch();
        result.runs = this.runs;
        result.started = false;
        result.finished = false;
        HashMap newMap = new HashMap();
        try {
            for (Object key : this.configurationObjects.keySet()) {
                Serializable newValue = StreamCopy.copy((Configuration)this.configurationObjects.get(key));
                newMap.put(key, newValue);
            }
        }
        catch (NotSerializableException e) {
            throw new RuntimeException(e);
        }
        result.configurationObjects = newMap;
        return result;
    }
}

