/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.fitness.pointset.AbstractAdjustableStaticMultiObjectiveRR;
import freak.module.fitness.pointset.LTSAdjust;
import freak.module.fitness.pointset.WrongNumberOfPointsException;
import freak.module.searchspace.PointSetGenotype;

public class LtSParetoQuantileOptimization
extends AbstractAdjustableStaticMultiObjectiveRR
implements Configurable {
    public LtSParetoQuantileOptimization(Schedule schedule) {
        super(schedule, new LTSAdjust());
        this.m_zName = "LTS (Least Trimmed Squares) 3-Pareto";
    }

    public String getDescription() {
        return "The fitness value of an individual is the least squares error of the  subset of points represented by the given individual.\n We restrict the search to subsets of size d for d-dimensional points, because they uniquely describe possible solutions.";
    }

    public int getDimensionOfObjectiveSpace() {
        return 3;
    }

    protected double[] evaluate(Genotype genotype) {
        double[] fitness = new double[3];
        try {
            this.calculateResiduals(genotype);
        }
        catch (WrongNumberOfPointsException e) {
            fitness[0] = e.getErrorFitnessValue() + this.offset;
            fitness[1] = Double.NEGATIVE_INFINITY;
            fitness[2] = Double.NEGATIVE_INFINITY;
            return fitness;
        }
        this.adjustHyperplane(genotype);
        if (this.interceptAdjust) {
            this.adjustIntercept(genotype);
        }
        this.rememberChoosenParameters();
        fitness[0] = this.evaluateResiduals();
        fitness[1] = this.evaluateResiduals((int)(0.25 * (double)((PointSetGenotype)genotype).getPoints().length));
        fitness[2] = this.evaluateResiduals((int)(0.75 * (double)((PointSetGenotype)genotype).getPoints().length));
        return fitness;
    }

    protected double evaluateResiduals() {
        return this.evaluateResiduals(this.h);
    }
}

