/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.fitness.FitnessFunction;
import freak.core.fitness.FitnessTransformer;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import freak.gui.JButtonFactory;
import freak.gui.ModuleList;
import freak.gui.scheduleeditor.FitnessTransformerDialog;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class PanelFitnessFunction
extends ScheduleEditorPanel {
    private Module[] fitnessFunctions;
    private JButton buConfigFitnessFunction;
    private JButton buEditTransformers;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel6;
    private JPanel jPanel3;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JList listFitnessFunctions;
    private JPanel panelTransformers;
    private JTextArea taDescrFitness;
    private JTable tableFitnessTransformer;
    private JTextField tfOptionsFitnessFunction;

    public PanelFitnessFunction(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.initComponents();
        DefaultTableModel tm = new DefaultTableModel(null, new Object[]{"Transformer", "Configuration"});
        this.tableFitnessTransformer.setModel(tm);
    }

    public static String getDescription() {
        return "Select Fitness Function";
    }

    public String getHelpURL() {
        return "node4.html#SECTION00442000000000000000";
    }

    protected void initForStartedSchedule() {
        this.listFitnessFunctions.setEnabled(false);
        this.buConfigFitnessFunction.setVisible(false);
        this.buEditTransformers.setVisible(false);
    }

    public boolean mayAdvance() {
        return this.schedule.getFitnessFunction() != null;
    }

    public void enter() {
        super.enter();
        this.fitnessFunctions = this.moduleCollector.getFitnessFunctions(this.schedule.getPhenotypeSearchSpace());
        FitnessFunction f = this.schedule.getRealFitnessFunction();
        ((ModuleList)this.listFitnessFunctions).setModules(this.fitnessFunctions, f);
        this.parseFitnessTransformers();
    }

    private void parseFitnessFunction() {
        FitnessFunction m = this.schedule.getRealFitnessFunction();
        if (m != null) {
            Util.displayText(this.taDescrFitness, m.getDescription());
            if (m instanceof Configurable) {
                Util.displayText(this.tfOptionsFitnessFunction, ((Configurable)((Object)m)).getConfiguration().getDescription());
            } else {
                Util.displayText(this.tfOptionsFitnessFunction, "<not configurable>");
            }
            this.buConfigFitnessFunction.setEnabled(m instanceof Configurable);
            this.buEditTransformers.setEnabled(m != null);
            this.scheduleEditor.updateComponents();
        } else {
            this.listFitnessFunctions.clearSelection();
        }
    }

    private void parseFitnessTransformers() {
        this.panelTransformers.setVisible(this.schedule.getFitnessFunction() instanceof FitnessTransformer);
        DefaultTableModel tm = (DefaultTableModel)this.tableFitnessTransformer.getModel();
        tm.setRowCount(0);
        List fitnessTransformers = Util.getFitnessTransformersFrom(this.schedule);
        for (FitnessTransformer ft : fitnessTransformers) {
            String confstr;
            if (ft instanceof Configurable) {
                Configuration conf = ((Configurable)((Object)ft)).getConfiguration();
                confstr = conf.getDescription();
            } else {
                confstr = "<not configurable>";
            }
            tm.addRow(new Object[]{ft.getName(), confstr});
        }
    }

    private void setRealFitnessFunction(FitnessFunction function) {
        FitnessFunction f = this.schedule.getFitnessFunction();
        if (f instanceof FitnessTransformer) {
            FitnessTransformer ft = (FitnessTransformer)f;
            while (ft != null) {
                if (ft.getFitnessFunction() instanceof FitnessTransformer) {
                    ft = (FitnessTransformer)ft.getFitnessFunction();
                    continue;
                }
                ft.setFitnessFunction(function);
                ft = null;
            }
        } else {
            this.schedule.setFitnessFunction(function);
        }
    }

    private void chainFitnessTransformers(List fitnessTransformers) {
        FitnessFunction f = this.schedule.getRealFitnessFunction();
        for (FitnessTransformer ft : fitnessTransformers) {
            ft.setFitnessFunction(f);
            f = ft;
        }
        this.schedule.setFitnessFunction(f);
        this.scheduleDependencyChecker.processNewFitnessFunction();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.listFitnessFunctions = new ModuleList();
        this.jScrollPane8 = new JScrollPane();
        this.taDescrFitness = new JTextArea();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel6 = new JLabel();
        this.tfOptionsFitnessFunction = new JTextField();
        this.buConfigFitnessFunction = JButtonFactory.newButton();
        this.buEditTransformers = JButtonFactory.newButton();
        this.panelTransformers = new JPanel();
        this.jScrollPane11 = new JScrollPane();
        this.tableFitnessTransformer = new JTable();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Select Fitness Function"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane7.setMinimumSize(new Dimension(220, 0));
        this.jScrollPane7.setPreferredSize(new Dimension(220, 0));
        this.listFitnessFunctions.setSelectionMode(0);
        this.listFitnessFunctions.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelFitnessFunction.this.listFitnessFunctionsValueChanged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.listFitnessFunctions);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel3.add((Component)this.jScrollPane7, gridBagConstraints);
        this.taDescrFitness.setEditable(false);
        this.taDescrFitness.setLineWrap(true);
        this.taDescrFitness.setText("<no fitness function selected>");
        this.taDescrFitness.setWrapStyleWord(true);
        this.jScrollPane8.setViewportView(this.taDescrFitness);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel3.add((Component)this.jScrollPane8, gridBagConstraints);
        this.jLabel20.setText("Fitness Functions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel6.setText("Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.tfOptionsFitnessFunction.setEditable(false);
        this.tfOptionsFitnessFunction.setText("<no fitness function selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanel3.add((Component)this.tfOptionsFitnessFunction, gridBagConstraints);
        this.buConfigFitnessFunction.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigFitnessFunction.setMnemonic('o');
        this.buConfigFitnessFunction.setText("Configure...");
        this.buConfigFitnessFunction.setEnabled(false);
        this.buConfigFitnessFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelFitnessFunction.this.buConfigFitnessFunctionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.buConfigFitnessFunction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.buEditTransformers.setText("Edit Fitness Transformers");
        this.buEditTransformers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelFitnessFunction.this.buEditTransformersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.buEditTransformers, gridBagConstraints);
        this.panelTransformers.setLayout(new GridBagLayout());
        this.panelTransformers.setBorder(new TitledBorder("Fitness Transformers"));
        this.tableFitnessTransformer.setEnabled(false);
        this.jScrollPane11.setViewportView(this.tableFitnessTransformer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.panelTransformers.add((Component)this.jScrollPane11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.panelTransformers, gridBagConstraints);
    }

    private void listFitnessFunctionsValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        FitnessFunction oldObj = this.schedule.getRealFitnessFunction();
        FitnessFunction newObj = (FitnessFunction)this.listFitnessFunctions.getSelectedValue();
        if (newObj != oldObj) {
            if (oldObj != null) {
                this.eventController.replaceGlobalEventSource(oldObj, newObj);
                this.eventController.removeModule(oldObj);
            }
            this.setRealFitnessFunction(newObj);
            this.scheduleDependencyChecker.processNewFitnessFunction();
            newObj.createEvents();
        }
        this.parseFitnessFunction();
        this.parseFitnessTransformers();
    }

    private void buConfigFitnessFunctionActionPerformed(ActionEvent evt) {
        String s = Util.configureModule(this.scheduleEditor, this.schedule.getRealFitnessFunction(), this.schedule);
        if (s != null) {
            Util.displayText(this.tfOptionsFitnessFunction, s);
            this.scheduleDependencyChecker.processNewModuleConfiguration(this.schedule.getFitnessFunction());
        }
    }

    private void buEditTransformersActionPerformed(ActionEvent evt) {
        FitnessTransformerDialog ftdlg = new FitnessTransformerDialog((Dialog)this.scheduleEditor, this.schedule);
        ftdlg.setVisible(true);
        List fts = ftdlg.getFitnessTransformers();
        this.chainFitnessTransformers(fts);
        this.parseFitnessTransformers();
        this.scheduleDependencyChecker.processNewFitnessFunction();
        this.scheduleEditor.updateComponents();
    }
}

