/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import freak.module.searchspace.logictree.Data;
import freak.module.searchspace.logictree.OperatorNode;
import freak.module.searchspace.logictree.StaticConstantNode;
import freak.module.searchspace.logictree.StaticInputNode;
import freak.rinterface.control.RFlags;
import java.io.Serializable;
import java.util.BitSet;

public class StaticCompareNode
implements OperatorNode,
Serializable {
    private StaticConstantNode constant;
    private StaticInputNode input;
    private boolean less;
    private boolean equal;
    private boolean greater;
    private BitSet fulfilling = null;

    public StaticCompareNode(StaticConstantNode cn, StaticInputNode in, boolean less, boolean equal, boolean greater, int numRows, int[][] rows) {
        this.constant = cn;
        this.input = in;
        this.less = less;
        this.equal = equal;
        this.greater = greater;
        this.createBitset(numRows, rows);
    }

    public StaticCompareNode(StaticConstantNode cn, StaticInputNode in, boolean less, boolean equal, boolean greater, BitSet fullf) {
        this.constant = cn;
        this.input = in;
        this.less = less;
        this.equal = equal;
        this.greater = greater;
        this.fulfilling = fullf;
    }

    public boolean getValue(int[] row) {
        boolean c;
        int i = this.input.getValue(row);
        int j = this.constant.getValue(row);
        boolean a = this.equal && i == j;
        boolean b = this.less && i < j;
        boolean bl = c = this.greater && i > j;
        return a || b || c;
    }

    private void createBitset(int numRows, int[][] rows) {
        if (numRows != rows.length) {
            return;
        }
        this.fulfilling = new BitSet(numRows);
        int i = 0;
        while (i < numRows) {
            this.fulfilling.set(i, this.getValue(rows[i]));
            ++i;
        }
    }

    public BitSet getValueBitset() {
        return this.fulfilling;
    }

    public int getSubtreeSize() {
        return 1;
    }

    StaticConstantNode getConstantChild() {
        return this.constant;
    }

    StaticInputNode getInputChild() {
        return this.input;
    }

    public BitSet getLiteralBitSet() {
        BitSet rueckgabe = new BitSet(Data.getNumCompareNodes());
        rueckgabe.clear();
        rueckgabe.set(Data.getIndexOfCompareNode(this));
        return rueckgabe;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StaticCompareNode)) {
            return false;
        }
        StaticCompareNode cn = (StaticCompareNode)o;
        return this.getConstantChild().equals(cn.getConstantChild()) && this.getInputChild().equals(cn.getInputChild());
    }

    public String toString() {
        String rueckgabe = "(" + this.input.toString();
        if (RFlags.getUseCase() == 2) {
            if (this.less && !this.greater) {
                rueckgabe = String.valueOf(rueckgabe) + "<";
            }
            if (this.equal) {
                rueckgabe = String.valueOf(rueckgabe) + "==";
            }
            if (this.greater && !this.less) {
                rueckgabe = String.valueOf(rueckgabe) + ">";
            }
            if (this.greater && this.less) {
                rueckgabe = String.valueOf(rueckgabe) + "!=";
            }
            rueckgabe = String.valueOf(rueckgabe) + this.constant.toString() + ")";
        } else {
            if (this.less) {
                rueckgabe = String.valueOf(rueckgabe) + "<";
            }
            if (this.equal) {
                rueckgabe = String.valueOf(rueckgabe) + "=";
            }
            if (this.greater) {
                rueckgabe = String.valueOf(rueckgabe) + ">";
            }
            rueckgabe = String.valueOf(rueckgabe) + this.constant.toString() + ")";
        }
        return rueckgabe;
    }

    public Object clone() {
        StaticConstantNode cn = (StaticConstantNode)this.constant.clone();
        StaticInputNode in = (StaticInputNode)this.input.clone();
        StaticCompareNode com = new StaticCompareNode(cn, in, this.less, this.equal, this.greater, (BitSet)this.fulfilling.clone());
        return com;
    }

    public void updateBitset() {
        this.createBitset(Data.getNumRows(), Data.getValues());
    }
}

