/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.permutation;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class Sort_HAM
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Sort_HAM(Schedule schedule) {
        super(schedule);
    }

    protected double evaluate(Genotype genotype) {
        return this.calculateHAM((PermutationGenotype)genotype);
    }

    public String getName() {
        return "Sorting with measure HAM";
    }

    public String getDescription() {
        return "The sorting problem can be viewed as an optimization problem: the sortedness of a sequence has to be maximized. We assume a_1 < a_2 < ... < a_n, so the optimal permutation is the identity. \nThe measure of sortedness used by this fitness function is HAM.\nHAM(pi) measures the number of indices i such that pi(i)=i (elements at the correct position).";
    }

    private int calculateHAM(PermutationGenotype gt) {
        int[] a = gt.getIntArray();
        int count = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] == i + 1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int n = ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int[] a = new int[n];
        int i = 0;
        while (i < n) {
            a[i] = i;
            ++i;
        }
        return new PermutationGenotype(a);
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return ((Permutation)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }
}

