% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.bulkQuery.R
\name{rforcecom.bulkQuery}
\alias{rforcecom.bulkQuery}
\title{Run Bulk Query}
\usage{
rforcecom.bulkQuery(session, 
                           soqlQuery,
                           object,
                           interval_seconds=5,
                           max_attempts=100, 
                           verbose=FALSE)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{soqlQuery}{a character string defining a SOQL query. (ex: "SELECT Id, Name FROM Account")}

\item{object}{a character string defining the target salesforce object that the operation will be performed on. 
This must match the target object in the query}

\item{interval_seconds}{an integer defining the seconds between attempts to check for job completion}

\item{max_attempts}{an integer defining then max number attempts to check for job completion before stopping}

\item{verbose}{a boolean on whether to print the API attempt numbers}
}
\value{
A \code{data.frame} of the recordset returned by query
}
\description{
This function is a convenience wrapper for submitting and retrieving 
bulk query API jobs
}
\examples{
\dontrun{
# select all Ids from Account object
ids <- rforcecom.bulkQuery(session, soqlQuery='Select Id from Account', object='Account')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk job salesforce api query
}

