% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendoboots.R
\name{vcov.rendo.boots}
\alias{vcov.rendo.boots}
\title{Calculate Variance-Covariance Matrix for Models Fitted with Bootstrapped Parameters}
\usage{
\method{vcov}{rendo.boots}(object, ...)
}
\arguments{
\item{object}{a fitted model object with bootstrapped parameters. Typically from \code{copulaCorrection}}

\item{...}{ignored, for consistency with the generic function.}
}
\value{
A matrix of the estimated covariances between the parameter estimates of the model.
The row and column names correspond to the parameter names given by the \code{coef} method.
}
\description{
The variance-covariance matrix is derived from the bootstrapped parameter estimates stored in the object.
It is based on Efron (1979) and calculates the result as follows:

\ifelse{html}{\out{<center> 1/(B-1) * &Sigma;(&theta;<sub>b</sub>-&theta;&#773)(&theta;<sub>b</sub>-&theta;&#773)' </center>}}{\deqn{\frac{1}{B-1}\sum_{b=1}^{B}{(\theta_b-\bar\theta)(\theta_b-\bar\theta)}}}

where B is the number of bootstraps and \ifelse{html}{\out{&theta;&#773}}{\eqn{\bar\theta}} is the mean of the bootstrapped coefficients.
}
\references{
Effron, B.(1979). "Bootstrap Methods: Another Look at the Jackknife", The Annals of Statistics, 7(1), 1-26.
}
