% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds2dd_detailed.R
\name{compact_vec}
\alias{compact_vec}
\title{Compacting a vector of any length with or without names}
\usage{
compact_vec(data, nm.sep = ": ", val.sep = "; ")
}
\arguments{
\item{data}{vector, optionally named}

\item{nm.sep}{string separating name from value if any}

\item{val.sep}{string separating values}
}
\value{
character string
}
\description{
Compacting a vector of any length with or without names
}
\examples{
sample(seq_len(4), 20, TRUE) |>
  as_factor() |>
  named_levels() |>
  sort() |>
  compact_vec()
1:6 |> compact_vec()
"test" |> compact_vec()
sample(letters[1:9], 20, TRUE) |> compact_vec()
}
