% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cosslett.R
\name{Cosslett}
\alias{Cosslett}
\title{Kiefer-Wolfowitz estimator for Cosslett (1983) estimator
Kiefer-Wolfowitz-Cosslett (1983) estimator for binary response model.  In the
primal form of the problem the pseudo log likelihood is:}
\usage{
Cosslett(x, y, v = 300, weights = NULL, ...)
}
\arguments{
\item{x}{is the observed utility difference between two choices, it would be
possible to extend this to make x a linear (index) function of some parameters}

\item{y}{is the binary outcome}

\item{v}{the unobserved utility difference taking values on a grid}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters to be passed to KWDual to control optimization}
}
\value{
an object of class density with the components:
	\item{x}{points of evaluation of the mixing density} 
	\item{y}{function values of the mixing density at x} 
\item{status}{exit code from the optimizer}
}
\description{
\deqn{l(f|y) =  sum_i [ y_i \log \sum_j (I(v_j <= x_i) * f_j) + 
		(1 - y_i) \log \sum_j (I(v_j > x_i) * f_j) ]}
}
\details{
as usual the implementation used here solves the corresponding dual problem.
Cumsum of the output y gives the CDF of the unobserved utility difference.
}
\author{
Jiaying Gu
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. Volume 27, Number 4 (1956), 887-906.
}
\keyword{nonparametric}

