% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{atom_chem_shift_corr}
\alias{atom_chem_shift_corr}
\title{Chemical shift correlation between given pair of atoms in a given amino acid (or) nucleic acid}
\usage{
atom_chem_shift_corr(atom1, atom2, res = NA)
}
\arguments{
\item{atom1}{atom name in NMR-STAR nomenclature like CA,CB2}

\item{atom2}{atom name in NMR-STAR nomenclature like HA,HB2}

\item{res}{residue name in NMR-STAR nomenclature like ALA}
}
\value{
plot object
}
\description{
Plots the correlated chemical shift distribution of given pair of atoms in a single residue  from BMRB database.
By default it will generate interactive graphics using plotly library
}
\examples{
#plt<-atom_chem_shift_corr('HE21','HE22','GLN')
#plots the chemical shift distribution between HE21 and HE22
}
\seealso{
\code{\link{fetch_res_chemical_shifts}} and \code{\link{chem_shift_corr}}
}
