% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bysite.R
\name{aqs_qa_pep_audit_by_site}
\alias{aqs_qa_pep_audit_by_site}
\title{aqs_qa_pep_audit_by_site}
\usage{
aqs_qa_pep_audit_by_site(
  parameter,
  bdate,
  edate,
  stateFIPS,
  countycode,
  sitenum,
  cbdate = NA_Date_,
  cedate = NA_Date_,
  return_header = FALSE
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zero) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{countycode}{a R character object which represents the 3 digit state
FIPS code for the county being requested (with leading
zero(s)). @seealso \code{\link[=aqs_counties_by_state]{aqs_counties_by_state()}} for the
list of available county codes for each state.}

\item{sitenum}{a R character object which represents the 4 digit site number
(with leading zeros) within the county and state being
requested.}

\item{cbdate}{a R date object which represents a "beginning
date of last change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object containing quality
assurance PEP audit data within a site. A AQS_Data_Mart_APIv2
object is a 2 item named list in which the first item (\$Header) is
a tibble of header information from the AQS API and the second item
(\$Data) is a tibble of the data returned.
}
\description{
\lifecycle{stable}
Returns a table of Performance Evaluation Program (PEP) audit
data aggregated by parameter code, stateFIPS, countycode and
site number for the time frame between bdate and edate.
}
\note{
The AQS API only allows for a single year of one point pep audit data
to be retrieved at a time. This function conveniently extracts date
information from the bdate and edate parameters then makes repeated
calls to the AQSAPI retrieving a maximum of one calendar year of data
at a time. Each calendar year of data requires a separate API call so
multiple years of data will require multiple API calls. As the number
of years of data being requested increases so does the length of time
that it will take to retrieve results. There is also a 5 second wait
time inserted between successive API calls to prevent overloading the
API server. This operation has a linear run time of
/(Big O notation: O/(n + 5 seconds/)/).
}
\examples{
# returns a aqs_v2 S3 object of pep Audit data for FRM PM2.5
          #  at the Huntsville Old Airport site (\#0014) in Madison County,
          #  AL for 2017
 \dontrun{aqs_qa_pep_audit_by_site(parameter = "88101",
                                   bdate = as.Date("20150101",
                                                   format = "\%Y\%m\%d"),
                                   edate = as.Date("20171231",
                                                     format = "\%Y\%m\%d"),
                                   stateFIPS = "01",
                                   countycode = "089",
                                   sitenum = "0014"
                                       )
           }
}
\seealso{
Other Aggregate _by_site functions: 
\code{\link{aqs_annualsummary_by_site}()},
\code{\link{aqs_dailysummary_by_site}()},
\code{\link{aqs_monitors_by_site}()},
\code{\link{aqs_qa_annualpeferomanceeval_by_site}()},
\code{\link{aqs_qa_annualperformanceevaltransaction_by_county}()},
\code{\link{aqs_qa_annualperformanceevaltransaction_by_site}()},
\code{\link{aqs_qa_blanks_by_site}()},
\code{\link{aqs_qa_collocated_assessments_by_site}()},
\code{\link{aqs_qa_flowrateaudit_by_site}()},
\code{\link{aqs_qa_flowrateverification_by_site}()},
\code{\link{aqs_qa_one_point_qc_by_site}()},
\code{\link{aqs_sampledata_by_site}()},
\code{\link{aqs_services_by_site}()},
\code{\link{aqs_transactionsample_by_site}()}
}
\concept{Aggregate _by_site functions}
