% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predCurves.r
\name{predCurves}
\alias{predCurves}
\title{Draws predicted curves (lines) using estimates from the fixed part of a
fitted model.}
\usage{
predCurves(object, indata = NULL, xname, group = NULL, legend = TRUE,
  legend.space = "top", legend.ncol = 2, ...)
}
\arguments{
\item{object}{Either an \code{\link{mlwinfitIGLS-class}} or \code{\link{mlwinfitMCMC-class}} object.}

\item{indata}{A data.frame object containing the data. If not specified, data is extracted from
the \code{object}.}

\item{xname}{The name of variable to be plotted.}

\item{group}{A character string or a sequence of length equivalent to rows of data to plot.
\code{group = NULL} by default.}

\item{legend}{A logical value indicating whether a legend for \code{group}
is to be added.}

\item{legend.space}{A character string specifies one of the four sides,
which can be one of \code{'top'}, \code{'bottom'}, \code{'left'} and \code{'right'}. Default,
\code{legend.space = 'top'}.}

\item{legend.ncol}{An integer specifies a number of columns, possibly
divided into blocks, each containing some rows. Default,
\code{legend.ncol = 2}.}

\item{...}{Other arguments to be passed to \code{\link[lattice]{xyplot}}.}
}
\description{
This function draws predicted curves (lines) against an explanatory variable
for each category of a categorical variable.
}
\examples{
\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved in location R2MLwiN defaults to, specify path via:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like this:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

## Read alevchem data
data(alevchem, package = "R2MLwiN")

alevchem$gcseav <- double2singlePrecision(alevchem$gcse_tot/alevchem$gcse_no - 6)
# Avoids warning when fitting factor as continuous response:
alevchem$a_point_num <- as.numeric(alevchem$a_point)

## Example: A-level Chemistry
(mymodel <- runMLwiN(a_point_num ~ 1 + gcseav + I(gcseav^2) + I(gcseav^3)
                     + gender + (1 | pupil), estoptions = list(EstM = 1,  resi.store = TRUE),
                     data = alevchem))

predCurves(mymodel, xname = "gcseav", group = "genderfemale")
}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{predLines}}
}

