% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ts.R
\name{plot_ts}
\alias{plot_ts}
\alias{plot_ts}
\alias{t_to_x}
\title{Plot time series !PLEASE USE plot_dts!}
\usage{
plot_ts(dt, type = "auto", col = "auto", lty = par("lty"),
  lwd = par("lwd"), pch = par("pch"), legend = c("topright", "topleft",
  "bottomright", "bottomleft", "n"), last_values = TRUE, main = "",
  ylim = "auto", xlim = "auto", time_range = "auto",
  resolution = "auto", log = par("ylog"), mar = par("mar"),
  xaxt = par("xaxt"), add = par("new"))

t_to_x(t)
}
\arguments{
\item{dt}{\code{data.table} with date/time index represented by first column. If OHLC detected then only candles plotted. Use \code{\link[graphics]{lines}} for the rest of data}

\item{type}{type vector or single value. Same as in \code{\link[graphics]{plot}} but \code{'candle'} supports. Default is \code{'l'}. \code{'h'} triggers adding zero to plot range}

\item{col}{color vector or single value. Default is \code{'auto'} so colors generated automatically}

\item{lty, lwd, pch}{parameters vectors or single values. Same as in \code{\link[graphics]{plot}}}

\item{legend}{position of plot legend. Supported positions are \code{'topright','topleft','bottomright','bottomleft'} or \code{'n'} to hide legend}

\item{last_values}{whether to add last values marks to the right of the plot. If vector specified marks added only for columns specified in vector}

\item{main}{title of the plot. Default is \code{''}}

\item{ylim}{y range of data to plot}

\item{xlim}{x range of data to plot}

\item{time_range}{time range in format \code{'HH:MM:SS/HH:MM:SS'}}

\item{resolution}{frequency of time marks on time axis. Supported resolutions are \code{'auto','minute','hour','day','month','year','years'}. Default is \code{'auto'}}

\item{log}{should y axis be in logarithmic scale?}

\item{mar}{same as in \code{\link[graphics]{par}}}

\item{xaxt}{same as in \code{\link[graphics]{par}}}

\item{add}{add to existing plot?}

\item{t}{date/time vector to be converted to plot x coordinates}
}
\description{
Plot time series !PLEASE USE plot_dts!
}
\details{
Plots time series each represented by columns of \code{times_series} on single plot. \cr
As for OHLC series, only one can be plotted and should be passed as \code{times_series} with 4 columns \code{'open','high','low','close'}.
}
\examples{
\donttest{

data( ticks )

time_series = to_candles( ticks, 60 * 10 )

plot_ts( time_series[ time \%bw\% '2016-05-13', list( time, open, high, low, close ) ] )
plot_ts( time_series[ time \%bw\% '2016-05-13', list( time, volume = volume / 1e6 )  ] , type = 'h' )
plot_ts( time_series[ time \%bw\% '2016-05', list( time, close ) ] )
plot_ts( time_series[ , list( time, close ) ] )
}
\donttest{

mar = par( 'mar' )
par( mar = c( 0, 4, 0, 4 ), xaxt = 'n' )
layout ( matrix( 1:(3 + 2) ), heights = c( 1, 4, 2, 2, 1 ) )
  empty_plot()
  plot_ts( time_series[ , list( time, open, high, low, close ) ] )
  plot_ts( time_series[ , list( time, close ) ] )
  par( xaxt = 's' )
  plot_ts( time_series[ , list( time, volume = volume / 1e6 ) ], type = 'h' )
  empty_plot()
par( mar = mar )
layout( matrix(1) )
}


}
\seealso{
Other graphical functions: \code{\link{add_last_values}},
  \code{\link{add_legend}}, \code{\link{distinct_colors}},
  \code{\link{empty_plot}}, \code{\link{hist_dt}},
  \code{\link{lines_ohlc}},
  \code{\link{lines_stacked_hist}},
  \code{\link{multi_heatmap}}, \code{\link{plot_table}}
}
