% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{roll_volume_profile}
\alias{roll_volume_profile}
\title{Rolling Volume Profile}
\usage{
roll_volume_profile(ticks, timeFrame, step, alpha, cut)
}
\arguments{
\item{ticks}{read 'Ticks' section in \link{Processor}}

\item{timeFrame}{indicator period in seconds, when to apply alpha correction}

\item{step}{price round off value, bar width}

\item{alpha}{multiplication coefficient must be between (0,1]}

\item{cut}{threshold volume when to delete bar}
}
\value{
data.table with columns \code{time, profile} where profile is data.table with columns \code{time, price, volume}
}
\description{
This indicator is not common. Volume profile is the distribution of volume over price. It is formed tick by tick and partially forgets past values over time interval. When volume on any bar is lower than specified critical value the bar is cut.
}
\seealso{
Other technical indicators: \code{\link{bbands}},
  \code{\link{crossover}}, \code{\link{ema}},
  \code{\link{roll_lm}}, \code{\link{roll_percent_rank}},
  \code{\link{roll_range}}, \code{\link{roll_sd}},
  \code{\link{rsi}}, \code{\link{sma}},
  \code{\link{stochastic}}
}
