% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_value.R
\name{normal_CV}
\alias{normal_CV}
\title{Compute the critical value for the KBQD tests for multivariate Normality}
\usage{
normal_CV(d, size, h, mu_hat, Sigma_hat, B = 150, Quantile = 0.95)
}
\arguments{
\item{d}{the dimension of generated samples.}

\item{size}{the number of observations to be generated.}

\item{h}{the concentration parameter for the Gaussian kernel.}

\item{mu_hat}{Mean vector for the reference distribution.}

\item{Sigma_hat}{Covariance matrix of the reference distribution.}

\item{B}{the number of replications.}

\item{Quantile}{the quantile of the distribution use to select the critical value}
}
\value{
the critical value for the specified dimension, size and level.
}
\description{
This function computes the empirical critical value for the Normality test
based on the KBQD tests using the centered Gaussian kernel.
}
\details{
For each replication, a sample from the d-dimensional Normal distribution with mean vector
\code{mu_hat} and covariance matrix \code{Sigma_hat} is generated and the KBQD test U-statistic for 
Normality is computed. 
After B iterations, the critical value is selected as the \code{Quantile} of the empirical distribution of the computed test statistics.
}
\keyword{internal}
