% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_direction.R
\name{test_direction}
\alias{test_direction}
\title{Test for differences in direction means with pairwise comparisons}
\usage{
test_direction(data, analysis = NULL)
}
\arguments{
\item{data}{A \code{track} R object, which is a list consisting of two elements:
\itemize{
\item \strong{\code{Trajectories}}: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
\item \strong{\code{Footprints}}: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
}}

\item{analysis}{A character string specifying the type of analysis: \code{"ANOVA"}, \code{"Kruskal-Wallis"}, or \code{"GLM"}. Default is \code{"ANOVA"}.}
}
\value{
A list with the results of the statistical analysis and diagnostic tests:
\itemize{
\item \code{normality_results}: A matrix of test statistics and \emph{p}-values from the Shapiro-Wilk test for each track, with rows for the test statistic and \emph{p}-value, and columns for each track.
\item \code{homogeneity_test}: The result of Levene's test, including the \emph{p}-value for homogeneity of variances.
\item \code{ANOVA} (If \code{analysis} is \code{"ANOVA"}): A list containing the ANOVA table and Tukey HSD post-hoc test results.
\item \code{Kruskal_Wallis} (If \code{analysis} is \code{"Kruskal-Wallis"}): A list containing the Kruskal-Wallis test result and Dunn's test post-hoc results.
\item \code{GLM} (If \code{analysis} is \code{"GLM"}): A summary of the GLM fit and pairwise comparisons.
}
}
\description{
\code{test_direction()} evaluates differences in mean direction across different tracks using a specified statistical test. It includes options for ANOVA, Kruskal-Wallis test, and Generalized Linear Models (GLM), and checks for assumptions such as normality and homogeneity of variances. For datasets with more than two tracks, it performs pairwise comparisons to identify specific differences between tracks.
}
\details{
The \code{test_direction()} function performs the following operations:
\itemize{
\item \strong{Condition Testing:}
\itemize{
\item \strong{Normality:} Shapiro-Wilk test for normality on step direction data within each track.
\item \strong{Homogeneity of Variances:} Levene's test for equal variances across tracks.
}
\item \strong{Statistical Analysis:}
\itemize{
\item \strong{ANOVA:} Compares step mean directions across tracks, assuming normality and homogeneity of variances. Includes Tukey's HSD post-hoc test for pairwise comparisons.
\item \strong{Kruskal-Wallis Test:} Non-parametric alternative to ANOVA for comparing step median directions across tracks when assumptions are violated. Includes Dunn's test for pairwise comparisons.
\item \strong{GLM:} Generalized Linear Model with a Gaussian family for comparing step means if ANOVA assumptions are not met. Pairwise comparisons in the GLM are conducted using estimated marginal means (least-squares means) with the \pkg{emmeans} package, which computes differences between group means while adjusting for multiple comparisons using Tukey’s method.
}
\item \strong{Direction Measurement:}
\itemize{
\item The direction is measured in degrees. The reference direction, or 0 degrees, is considered to be along the positive x-axis. Angles are measured counterclockwise from the positive x-axis, with 0 degrees pointing directly along this axis.
}
}
}
\section{Logo}{

\if{html}{\figure{Logo.png}{options: width=30\%}}
}

\examples{
# Example 1: Test for Differences in Direction Means with Pairwise Comparisons in MountTom dataset
test_direction(MountTom, analysis = "ANOVA")

# Example 2: Test for Differences in Direction Means with Pairwise Comparisons in MountTom dataset
test_direction(MountTom, analysis = "Kruskal-Wallis")

# Example 3: Test for Differences in Direction Means with Pairwise Comparisons in MountTom dataset
test_direction(MountTom, analysis = "GLM")

# Example 4: Test for Differences in Direction Means with Pairwise Comparisons in PaluxyRiver
# dataset
test_direction(PaluxyRiver, analysis = "ANOVA")

# Example 5: Test for Differences in Direction Means with Pairwise Comparisons in PaluxyRiver
# dataset
test_direction(PaluxyRiver, analysis = "Kruskal-Wallis")

# Example 6: Test for Differences in Direction Means with Pairwise Comparisons in PaluxyRiver
# dataset
test_direction(PaluxyRiver, analysis = "GLM")

}
\seealso{
\code{\link{tps_to_track}}, \code{\link{plot_direction}}
}
\author{
Humberto G. Ferrón

humberto.ferron@uv.es

Macroevolution and Functional Morphology Research Group (www.macrofun.es)

Cavanilles Institute of Biodiversity and Evolutionary Biology

Calle Catedrático José Beltrán Martínez, nº 2

46980 Paterna - Valencia - Spain

Phone: +34 (9635) 44477
}
