% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Rep_Code.R
\name{unbal.two.factor.rep}
\alias{unbal.two.factor.rep}
\title{Measure of (unadjusted) repeatability with missing values}
\usage{
unbal.two.factor.rep(dataset, k.est.meth = 1, gamma = 1)
}
\arguments{
\item{dataset}{data frame of diet estimates. Columns 1 and 2 of
\code{dataset} must be the first and second factors in your two factor
ANOVA model where column 1 specifies the predator and column 2 the
year, season, etc...  Missing values are allowed.}

\item{k.est.meth}{default is 1 (harmonic mean).  See details below.}

\item{gamma}{needed to compute CS distance.  Default is 1.}
}
\value{
unadjusted consistent repeatability, unadjusted absolute repeatability
        and a modified measure of repeatability.
}
\description{
Measure of (unadjusted) repeatability with missing values
}
\details{
We use the modified measure of repeatability that uses an adjusted
         degrees of freedom and takes into account the estimate of \code{k}.
         When \code{k.est.meth=1}, the harmonic mean is used (see
         p. 212 from Biometry Fourth Edition by Sokal and Rohlf) and when
         \code{k.est.meth=2},estimate is n_0 from Lessels and Boag (1987).
}
\keyword{internal}
