% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitSpatial_R.R
\docType{class}
\name{SpatialProbit-class}
\alias{SpatialProbit}
\alias{SpatialProbit-class}
\title{Class of Spatial Probit Model.}
\description{
Class of Spatial Probit Model.
}
\section{Slots}{

\describe{
\item{\code{beta}}{numeric, the estimated parameters for the covariates.}

\item{\code{rho}}{numeric, the estimated spatial dependence parameter.}

\item{\code{coeff}}{numeric, all estimated parameters.}

\item{\code{loglik}}{numeric, the likelihood associated to the estimated model.}

\item{\code{formula}}{\code{formula}.}

\item{\code{nobs}}{numeric, number of observations.}

\item{\code{nvar}}{numeric, number of covariates.}

\item{\code{y}}{numeric, vector of observed dependent variable.}

\item{\code{X}}{matrix, matrix of covariates.}

\item{\code{time}}{numeric, estimation time.}

\item{\code{DGP}}{character, DGP of the model (SAR or SEM).}

\item{\code{method}}{character, estimation method ("\code{conditional}" or 
"\code{full-lik}").}

\item{\code{varcov}}{character, indicates the matrix used in the algorithm 
("\code{varcov}" or "\code{precision}").}

\item{\code{W}}{SparseMatrix, the spatial weight matrix.}

\item{\code{iW_CL}}{numeric, the order of approximation used in the conditional 
method.}

\item{\code{iW_FL}}{numeric, the order of approximation used inside the likelihood 
function for the \code{full-lik} method.}

\item{\code{iW_FG}}{numeric, the order of approximation used inside the gradient 
functions for the \code{full-lik} method.}

\item{\code{reltol}}{numeric, the relative convergence tolerance.}

\item{\code{prune}}{numeric, the pruning for the gradient functions.}

\item{\code{env}}{an \code{environment} containing information for use in later 
function calls to save time.}

\item{\code{message}}{a integer giving any additional information or NULL.}
}}

