% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_member_vote_position.R
\name{get_member_vote_position}
\alias{get_member_vote_position}
\title{Get a Specific Member’s Vote Positions}
\usage{
get_member_vote_position(member_id, myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the most recent vote positions for a specific member of the House of Representatives or Senate
}
\description{
To get the most recent vote positions for a specific member of the House of Representatives or Senate. HTTP Request: GET https://api.propublica.org/congress/v1/members/{member-id}/votes.json
}
\examples{
\donttest{
get_member_vote_position('K000388')
}
}
