% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_committee_electioneering_communications.R
\name{get_committee_electioneering_communications}
\alias{get_committee_electioneering_communications}
\title{Get Electioneering Communications by Specific Committee}
\usage{
get_committee_electioneering_communications(cycle = 2018, FEC_ID,
  myAPI_Key)
}
\arguments{
\item{cycle}{The election cycle}

\item{FEC_ID}{The FEC-assigned 9-character ID of a committee.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recently added FEC independent expenditure-only committees, known as “super PACs” from the campaign-finance API from ProPublica.
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/committees/{fec-id}/electioneering_communications
}
\examples{
\donttest{
get_committee_electioneering_communications(2016, 'C30002034')

}
}
