% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/location.R
\name{location}
\alias{location}
\title{Hierarchical plot of biological network}
\usage{
location(graph, species = c("human", "ath"), vertex.color = 1,
  vertex.size = 10, vertex.shape = "square", edge.color = 1,
  label.add = TRUE, colorbar.add = TRUE, xlim = c(-1, 1), ylim = c(-1,
  1), ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{species}{The species name, currently only \code{human} and \code{ath} are available.}

\item{vertex.color}{Color of the vertex. Default value is \code{1}.}

\item{vertex.size}{Size of the vertex. Default value is \code{10}.}

\item{vertex.shape}{Shape of the vertex. Default value is \code{square}.}

\item{edge.color}{Color of the edge. Default value is \code{1}.}

\item{label.add}{Boolean value, whether to add label to the plot (if \code{TRUE}) or not (if \code{FALSE}).}

\item{colorbar.add}{Boolean value, whether to add colorbar to the plot (if \code{TRUE}) or not (if \code{FALSE}).}

\item{xlim}{A vector indicating the range of x axis.}

\item{ylim}{A vector indicating the range of y axis.}

\item{...}{Other arguments.}
}
\value{
A hierarchical plot of biological network.
}
\description{
Hierarchical plot of biological network according to the elements' subcellular location.
}
\examples{
gene<-data.frame(c("DVL1","DVL2","DVL3"))
net<-construction(input=gene,db="HPRD",species="human",ID.type="Gene symbol",hierarchy=1)
location(net,species="human",vertex.color="vertex.hierarchy")
}
\references{
Barsky A, Gardy JL, Hancock REW, and Munzner T. (2007) Cerebral: a Cytoscape plugin for layout of and interaction with biological networks using subcellular localization annotation. Bioinformatics 23(8):1040-2.
}

