% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bilateral_indicators.R
\name{bennet}
\alias{bennet}
\title{Calculating the Bennet price and quantity indicators}
\usage{
bennet(
  data,
  start,
  end,
  interval = FALSE,
  matched = FALSE,
  contributions = FALSE,
  prec = 2
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric) and \code{prodID} (as numeric, factor or character). A column \code{quantities} (as positive numeric) is also needed because this function uses unit values as monthly prices.}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{interval}{A logical parameter indicating whether calculations are to be made for the whole time interval (TRUE) or no (FALSE).}

\item{matched}{A logical parameter indicating whether the matched sample approach is to be used (if yes, the parameter has the value TRUE).}

\item{contributions}{A logical parameter indicating whether contributions of individual products are to be displayed. If it is \code{TRUE}, then contributions are calculated for the the base period \code{start} and the current period \code{end}.}

\item{prec}{A numeric vector indicating precision, i.e. the number of decimal places for presenting results.}
}
\value{
This function returns the Bennet price and quantity indicators and optionally also the price and quantity contributions of individual products.
}
\description{
This function returns the Bennet price and quantity indicators and optionally also the price and quantity contributions of individual products.
}
\examples{
bennet(milk, "2018-12", "2019-12", matched=TRUE, contributions=TRUE)
\donttest{bennet(coffee, start="2018-12", end="2019-03", interval=TRUE)}
}
\references{
{Bennet, T. L. (1920). \emph{The Theory of Measurement of Changes in Cost of Living}. Journal of the Royal Statistical Society, 83, 455-462.}

{Białek, J. (2024). \emph{The use of the Bennet indicators and their transitive versions for scanner data analysis}. Statistics in Transition new series, 25(3).}
}
