% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{gk}
\alias{gk}
\title{Calculating the multilateral Geary-Khamis price index}
\usage{
gk(data, start, end, wstart = start, window = 13)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{wstart}{The beginning of the time interval (which is used by multilateral methods) limited to the year and month, e.g. "2020-01".}

\item{window}{The length of the time window (as positive integer: typically multilateral methods are based on the 13-month time window).}
}
\value{
This function returns a value of the multilateral Geary-Khamis price index which considers the time window defined by \code{wstart} and \code{window} parameters. The Geary-Khamis price index is calculated by using a special iterative algorithm from \code{Chessa (2016)}. It measures the price dynamics by comparing period \code{end} to period \code{start} (both \code{start} and \code{end} must be inside the considered time window). To get information about both price index values and corresponding dates, please see functions: \code{\link{price_index}}, \code{\link{price_indices}} or \code{\link{final_index}}. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} or the \code{\link{final_index2}} function).
}
\description{
This function returns a value of the multilateral Geary-Khamis price index.
}
\examples{
\donttest{gk(milk, start="2019-01", end="2019-08",window=10)}
\donttest{gk(milk, start="2018-12", end="2019-12")}
}
\references{
{Geary, R. G. (1958). \emph{A Note on Comparisons of Exchange Rates and Purchasing Power between Countries.} Journal of the Royal Statistical Society, Series A, 121, 97-99.}

{Khamis, S. H. (1970). \emph{Properties and Conditions for the Existence of a new Type of Index Number.} Sankhya Series B32, 81-98.}

{Chessa, A.G. (2016). \emph{A New Methodology for Processing Scanner Data in the Dutch CPI.} Eurona 1/2016, 49-69.}
}
