% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_phylo.R
\name{AntibodyForests_phylo}
\alias{AntibodyForests_phylo}
\title{Converts the igraph networks of a given AntibodyForests object into a given (useful to convert the minimum spanning trees into a phylogenetic tree)}
\usage{
AntibodyForests_phylo(trees, output.format, solve.multichotomies, parallel)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects or single object, as obtained from the AntibodyForests function.}

\item{output.format}{string - 'treedata' will output the phylogenetic tree as a tidytree treedata object, 'phylo' as an ape::phylo object.}

\item{solve.multichotomies}{boolean - whether to remove multichotomies in the resulting phylogenetic tree using ape::multi2di}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package to be installed.}
}
\value{
nested list of AntibodyForests objects for each clonotype and each sample/timepoint or a single object, with a new phylo slot for the phylogenetic tree.
}
\description{
Will automatically convert the minimum spanning trees in a given AntibodyForests object into a phylogenetic tree as a phylo object. This new object will be added into the phylo slot of the AntibodyForests object.
}
\examples{
\dontrun{
AntibodyForests_phylo(trees, output.format = 'phylo')
}
}
