% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_topN_DE_genes_per_cluster.R
\name{GEX_topN_DE_genes_per_cluster}
\alias{GEX_topN_DE_genes_per_cluster}
\title{Organizes the top N genes that define each Seurat cluster and converts them into a single dataframe. This can be useful for obtaining insight into cluster-specific phenotypes.}
\usage{
GEX_topN_DE_genes_per_cluster(GEX_cluster_genes.output, n.genes, by_FC, filter)
}
\arguments{
\item{GEX_cluster_genes.output}{The output from the GEX_cluster_genes function - this should be a list with each list element corresponding to the genes, p values, logFC, pct expression for the genes differentially regulated for each cluster.}

\item{n.genes}{The number of genes to be selected from each cluster. If n.genes is higher than the number of cells in a cluster then it is silently adjusted to be}

\item{by_FC}{Logical indicating if the top n genes are selected based on the logFC value instead of p value. Default is FALSE.}

\item{filter}{Character vector of initials of the genes to be filtered. Default is c("MT-", "RPL", "RPS"), which filters mitochondrial and ribosomal genes.}
}
\value{
Returns a dataframe in which the top N genes defining each cluster based on differential expression are selected.
}
\description{
Organizes the top N genes that define each Seurat cluster and converts them into a single dataframe. This can be useful for obtaining insight into cluster-specific phenotypes.
}
\examples{
\dontrun{
GEX_topDE_genes_per_cluster(GEX_cluster_genes.output=list_of_genes_per_cluster
, n.genes=20, by_FC=FALSE, filter=c("MT-", "RPS", "RPL"))
}
}
