% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_integrate.R
\name{VDJ_GEX_integrate}
\alias{VDJ_GEX_integrate}
\title{only Platypus v2 Integrates VDJ and gene expression libraries by providing cluster membership seq_per_vdj object and the index of the cell in the Seurat RNA-seq object.}
\usage{
VDJ_GEX_integrate(GEX.object, clonotype.list, VDJ.per.clone, clonotype.level)
}
\arguments{
\item{GEX.object}{A single seurat object from automate_GEX function. This will likely be supplied as automate_GEX.output[[1]].}

\item{clonotype.list}{Output from either VDJ_analyze or VDJ_clonotype functions. This list should correspond to a single GEX.list object, in which each list element in clonotype.list is found in the GEX.object. Furthermore, these repertoires should be found in the automate_GEX library.}

\item{VDJ.per.clone}{Output from the VDJ_per_clone function. Each element in the list should be found in the output from the automate_GEX function.}

\item{clonotype.level}{Logical specifying whether the integration should occur on the cellular level (VDJ_per_clone) or on the clonotype level (e.g. output from VDJ_analyze or VDJ_clonotype). TRUE specifies that the clonotype level will be selected - e.g. the clonotype.list object will now contain information from the GEX object regarding clonal membership.}
}
\value{
Returns a nested list containing information corresponding to either the clonal level or the sequence level, depending on the input argument "clonotype.level". This function essentially will update the output of the analyze_VDJ or the VDJ_per_clone functions.
}
\description{
only Platypus v2 Integrates VDJ and gene expression libraries by providing cluster membership seq_per_vdj object and the index of the cell in the Seurat RNA-seq object.
}
\examples{
\dontrun{
testing_integrate <- VDJ_GEX_integrate(GEX.object = automate.gex.output[[1]]
,clonotype.list =  VDJ.analyze.output
,VDJ.per.clone = VDJ.per.clone.output,clonotype.level = TRUE)
}
}
