% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReturnMeansAgent.R
\name{ReturnMeansAgent}
\alias{ReturnMeansAgent}
\title{Gives true mean survival times for doses considered of the experimental agent.}
\usage{
ReturnMeansAgent(PE, PT, beta, Dose, Family, alpha)
}
\arguments{
\item{PE}{True efficacy dose-toxicity vector.}

\item{PT}{True toxicity dose-toxicity vector.}

\item{beta}{True linear term for the rate or mean parameter}

\item{Dose}{Vector of standardized doses considered in the trial.}

\item{Family}{Time to event distribution. Options include: Exponential, Gamma, Weibull, Lognormal.}

\item{alpha}{Shape parameter or standard deviation of a lognormal distribution.}
}
\description{
Returns the dose specific mean survival times for given efficacy and toxicity dose probability vector, distribution family and linear relationship between dose, effiacy, toxicity and survival.
}
\examples{
##True Efficacy and Toxicity Probabilities
PT = c(.1,.15,.25,.35,.5)
PE=c(.2,.4,.6,.65,.7)
##Dose Levels considered
Dose = c(1,2,3,3.5,5)
Dose=(Dose-mean(Dose))/sd(Dose)
###Family of Distributions
Family="Gamma"
###Shape parameter ## Doesn't matter for exponential distribution
alpha=2
###True Beta vector
beta = c(.75,-.5, .3, -.25,2.143)
ReturnMeansAgent(PE,PT,beta,Dose,Family,alpha)
}
\references{
[1] Chapple and Thall (2018). A Hybrid Phase 12/3 Clinical Trial Design Allowing Dose Re-Optimization in Phase 3 Biometrics. Under Review.
}
