% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{pet.get}
\alias{pet.get}
\title{Returns the available pet record data for the input pet Ids.}
\usage{
pet.get(petId, return_df = FALSE)
}
\arguments{
\item{petId}{ID of the pet record to return. Accepts a character for a single
record or a list or vector of petIds.}

\item{return_df}{If TRUE, the function will coerce the output JSON from the
Petfinder API into a data.frame}
}
\value{
data.frame of input petId(s).
}
\description{
Returns the available pet record data for the input pet Ids.
}
\examples{
\dontrun{
pf <- Petfinder(key) # Initialize Petfinder class
pf$pet.get(petId)
petIds <- c(petId1, petId2, petId3)
pf$pet.get(petIds)
}
}
