% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_Extrapolation}
\alias{Pareto_Extrapolation}
\title{Pareto Extrapolation}
\usage{
Pareto_Extrapolation(
  Cover_1,
  AttachmentPoint_1,
  Cover_2,
  AttachmentPoint_2,
  alpha,
  ExpLoss_1 = NULL,
  truncation = NULL
)
}
\arguments{
\item{Cover_1}{Numeric. Cover of the layer from which we extrapolate. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint_1}{Numeric. Attachment point of the layer from which we extrapolate.}

\item{Cover_2}{Numeric. Cover of the layer to which we extrapolate. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint_2}{Numeric. Attachment point of the layer to which we extrapolate.}

\item{alpha}{Numeric. Pareto alpha used for the extrapolation.}

\item{ExpLoss_1}{Numeric. Expected loss of the layer from which we extrapolate. If \code{NULL} (default) then the function provides only the ratio between the expected losses of the layers.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > AttachmentPoint_1}, then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
The expected loss of the layer \code{Cover_2} xs \code{AttachmentPoint_2} given that  \code{Cover_1} xs \code{AttachmentPoint_1} has expected
loss \code{ExpLoss_1} and assuming a (truncated) Pareto distribution with parameters \code{t} and \code{alpha}. If missing then \code{ExpLoss_1 == 1} is assumed.
}
\description{
Uses a Pareto distribution to derive the expected loss of a layer from the expected loss of another layer
}
\examples{
Pareto_Extrapolation(1000, 1000, 2000, 2000, 2, ExpLoss_1 = 100)
Pareto_Extrapolation(1000, 1000, 2000, 2000, 2) * 100
Pareto_Extrapolation(1000, 1000, 2000, 2000, 2, truncation = 5000, ExpLoss_1 = 100)
Pareto_Extrapolation(1000, 1000, 2000, 2000, 2, truncation = 5000) * 100

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
