% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_parseData.R
\name{generic_parseData}
\alias{generic_parseData}
\title{Parse generic air quality files}
\usage{
generic_parseData(fileString = NULL, configList = NULL)
}
\arguments{
\item{fileString}{Character string of delimited data to parse.}

\item{configList}{A \code{R} \code{list} or JSON file containing key-value
pairs which affect how the parsing of \code{fileString} is handled. If
\code{configList} is in JSON format, it can be passed in as a file, string,
or URL.}
}
\value{
A tibble of the data contined in \code{fileString} parsed according
  to parameters in \code{configList}. The data is coerced into a format that
  is more easily convertable into a \code{ws_monitor} object at a later
  point.
}
\description{
Given a string of delimited file data, this function will parse the file as
a table of data an apply some transformations and augmentations as specified
by a given configuration list.
}
\section{Parsing data}{

Internally, this function uses \code{\link[readr]{read_delim}} to convert
\code{fileString} into a tibble. If any lines of data cannot be properly
parsed, and error will be thrown anf the problem lines will be printed.
}

\section{Creating a configList}{

For more information on how to build a \code{configList}, see the Rmarkdown
document "Working with Generic Data" in the \code{localNotebooks} directory.
}

\examples{
filePath <- system.file(
  "extdata", "generic_data_example.csv",
  package = "PWFSLSmoke",
  mustWork = TRUE
)

configPath <- system.file(
  "extdata", "generic_configList_example.json",
  package = "PWFSLSmoke",
  mustWork = TRUE
)

configList <- jsonlite::fromJSON(configPath)
fileString <- generic_downloadData(filePath)
parsedData <- generic_parseData(fileString, configList)
}
