% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIcon.R
\name{addIcon}
\alias{addIcon}
\title{Add Icons to a Map or RgoogleMap Plot}
\usage{
addIcon(icon, longitude, latitude, map = NULL, expansion = 0.1,
  pos = 0)
}
\arguments{
\item{icon}{object to be plotted}

\item{longitude}{vector of longitudes}

\item{latitude}{vector of latitudes}

\item{map}{optional RgoogleMaps map object}

\item{expansion}{icon expansion factor}

\item{pos}{position of icon relative to location (0=center, 1=bottom, 2=left, 3=top,4=right)}
}
\description{
Adds an icon to \code{map} -- an RgoogleMaps map object.
The following icons are available:

\itemize{
\item{\code{orangeFlame}}{ -- yellow-orange flame}
\item{\code{redFlame}}{ -- orange-red flame}
}

You can use other .png files as icons by passing an absolute path as the \code{icon} argument.
}
\note{
For RgoogleMaps, the \code{expansion} will be ~ 0.1 while for basic plots it may need
to be much smaller, perhaps ~ 0.001.
}
\examples{
\dontrun{
ca <- loadLatest() \%>\% monitor_subset(stateCodes='CA')
# Google map
map <- monitor_esriMap(ca)
addIcon("orangeFlame", ca$meta$longitude, ca$meta$latitude, map=map, expansion=0.1)
# line map
monitor_map(ca)
addIcon("orangeFlame", ca$meta$longitude, ca$meta$latitude, expansion=0.002)
}
}
