% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_isolate.R
\name{monitor_isolate}
\alias{monitor_isolate}
\title{Isolate Individual Monitors}
\usage{
monitor_isolate(ws_monitor, xlim = NULL, ylim = NULL, tlim = NULL,
  monitorIDs = NULL, stateCodes = NULL, timezone = "UTC")
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{xlim}{optional vector with low and high longitude limits}

\item{ylim}{optional vector with low and high latitude limits}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH] or \code{POSIXct})}

\item{monitorIDs}{optional vector of monitorIDs}

\item{stateCodes}{optional vector of stateCodes}

\item{timezone}{Olson timezone passed to \code{link{parseDatetime}} when parsing numeric \code{tlim}}
}
\value{
A list of isolated ws_monitor objects.
}
\description{
Filters \code{ws_monitor} according to the parameters
passed in.  If any parameter is not specified, that parameter will not be used in the filtering.

After filtering, each monitorID found in \code{ws_monitor} is extracted
and its \code{data} dataframe is restricted to the times from when that monitor first
datapoint until its last datapoint.

This function is useful when \emph{ws_monitor} objects are created for
mobile monitors that are deployed to different locations in different years.
}
\examples{
N_M <- Northwest_Megafires
# monitorLeaflet(N_M) # to identify Spokane monitorIDs
Spokane <- monitor_subsetBy(N_M, stringr::str_detect(N_M$meta$monitorID,'^53063'))
Spokane$meta$monitorID
monitorList <- monitor_isolate(Spokane)
names(monitorList)
}
\seealso{
\link{monitor_subset}
}
\keyword{ws_monitor}
