% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{plr_cleaning}
\alias{plr_cleaning}
\title{Basic Data Cleaning}
\usage{
plr_cleaning(
  df,
  var_list,
  irrad_thresh = 100,
  low_power_thresh = 0.05,
  high_power_cutoff = NA,
  tmst_format = "\%Y-\%m-\%d \%H:\%M:\%S"
)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{var_list}{A list of the dataframe's standard variable names, obtained from
the output of \code{\link{plr_variable_check}}.}

\item{irrad_thresh}{The lowest meaningful irradiance value.
Values below are filtered.}

\item{low_power_thresh}{The lowest meaningful power output.
Values below are filtered.}

\item{high_power_cutoff}{The highest meaningful power output.
Values above are filtered.}

\item{tmst_format}{The desired timestamp format.}
}
\value{
Returns dataframe with rows filtered out based on passed cleaning parameters
}
\description{
Removes entries with irradiance and power readings outside cutoffs,
  fixes timestamps to your specified format, and converts columns to numeric
  when appropriate - see \code{\link{plr_convert_columns}}. 
  Also, adds columns for days/weeks/years of operation that are used by
  other functions.
}
\examples{
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
                               
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)

}
