% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fas.lm.R
\name{fas.lm}
\alias{fas.lm}
\title{Linear Furusawa and Smith Diffusion Model}
\usage{
fas.lm(t, Ct, m, V, b, Co)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{Ct}{the numerical value for the concentration of the adsorbent at time t. This parameter should not contain a value equal to zero. Any row(s) that contain(s) value of Ct equal to zero will be automatically removed to proceed with the calculation.}

\item{m}{the numerical value for mass of adsorbent}

\item{V}{the numerical value for volume of solution}

\item{b}{the numerical value for the Langmuir isotherm constant}

\item{Co}{the numerical value for the initial concentration of the adsorbent}
}
\value{
the linear regression and the parameter estimation for the Furusawa and Smith Diffusion Model
}
\description{
The Furusawa and Smith Diffusion Model is known to describe the rate of adsorption, assuming that only external diffusion resistance was predominant during the initial adsorption period and controlled the adsorption rate. The diffusion model relates the change in fluid phase concentration and time with the fluid phase concentration at the external surface and an external mass transfer coefficient (Furusawa & Smith, 1974).
}
\examples{
t <- c(0,15,30,45,60,75,90,105,120)
Ct <- c(10.000,8.141,8.056,7.949,7.863,7.799,7.778,7.756,7.692)
m <- 0.05
V <- 0.1
b <- 1.3
Co <- 10
fas.lm(t,Ct,m,V,b,Co)
}
\references{
Furusawa, T., & Smith, J. M. (1974) <doi:10.1002/aic.690200111> Intraparticle mass transport in slurries by dynamic adsorption studies. AIChE Journal, 20(1), 88–93.

Yakub, E., Agarry, S. E., Omoruwou, F., &; Owabor, C. N. (2020) <doi:10.1080/02726351.2019.1616862> Comparative study of the batch adsorption kinetics and mass transfer in phenol-sand and phenol-clay adsorption systems. Particulate Science and Technology, 38(7).
}
\author{
Jeff Ryan S. Magalong

Joshua Z. Dela Cruz

Jeann M. Bumatay

Chester C. Deocaris
}
