% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcMetric.R
\docType{class}
\name{qcMetric-class}
\alias{qcMetric-class}
\alias{qcMetric}
\title{Class which can compute plots and generate mzQC output (usually for a single metric).}
\description{
Reference class which is instanciated with a metric description and a
worker function (at initialization time, i.e. in the package)
and can produce plots and mzQC values (at runtime, when data is provided) using setData().
}
\section{Fields}{

\describe{
\item{\code{helpText}}{Description (lengthy) of the metric and plot elements}

\item{\code{workerFcn}}{Function which generates a result (usually plots). Data is provided using setData().}

\item{\code{plots}}{List of plots (after setData() was called)}

\item{\code{qcScores}}{Data.frame of scores from a qcMetric (computed within workerFcn())}

\item{\code{mzQC}}{An named list of mzQC MzQCqualityMetric's (named by their fc.raw.file for runQuality or concatenated fc.raw.files for setQualities (e.g. "file 1;file4")) (valid after setData() was called)}

\item{\code{qcCat}}{QC category (LC, MS, or prep)}

\item{\code{qcName}}{Name of the qcScore in the heatmap}

\item{\code{orderNr}}{Column index during heatmap generation and for the general order of plots}
}}


\examples{

require(ggplot2)
dd = data.frame(x=1:10, y=11:20)
a = qcMetric$new(helpText="small help text", 
                 ## arbitrary arguments, matched during setData()
                 workerFcn=function(.self, data, gtit)
                 {
                   ## usually some code here to produce ggplots
                   pl = lapply(1:2, function(xx) {
                       ggplot(data) +
                         geom_point(aes(x=x*xx,y=y)) +
                         ggtitle(gtit)
                     })
                   return(list(plots = pl))
                 }, 
                 qcCat="LC", 
                 qcName="MS/MS Peak shape", 
                 orderNr = 30)
## test some output
a$setData(dd, "my title")
a$plots  ## the raw plots
a$getPlots(TRUE) ## same as above
a$getPlots(FALSE) ## plots without title
a$getTitles()  ## get the titles of the all plots
a$helpText
a$qcName



}
