% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cocobot.R
\name{cocobot}
\alias{cocobot}
\title{Conditional continuous by ordinal tests for association.}
\usage{
cocobot(formula, data, link = c("logit", "probit", "cloglog", "cauchit"),
  subset, na.action = getOption("na.action"), emp = TRUE, fisher = FALSE,
  conf.int = 0.95)
}
\arguments{
\item{formula}{an object of class \code{\link{Formula}} (or one
that can be coerced to that class): a symbolic description of the
model to be fitted.  The details of model specification are given
under \sQuote{Details}.}

\item{data}{an optional data frame, list or environment (or object
coercible by \code{\link{as.data.frame}} to a data frame)
containing the variables in the model.  If not found in
\code{data}, the variables are taken from
\code{environment(formula)}, typically the environment from which
\code{cocobot} is called.}

\item{link}{The link family to be used for the ordinal model of
\var{X} on \var{Z}.  Defaults to \samp{logit}. Other options are
\samp{probit}, \samp{cloglog}, and \samp{cauchit}.}

\item{subset}{an optional vector specifying a subset of
observations to be used in the fitting process.}

\item{na.action}{action to take when \code{NA} present in data.}

\item{emp}{logical indicating whether the residuals from the model of
\var{Y} on \var{Z} are computed based on the assumption of normality (\code{FALSE})
or empirically (\code{TRUE}).}

\item{fisher}{logical indicating whether to apply fisher transformation to compute confidence intervals and p-values for the correlation.}

\item{conf.int}{numeric specifying confidence interval coverage.}
}
\value{
object of \samp{cocobot} class.
}
\description{
\code{cocobot} tests for independence between an ordered categorical
variable, \var{X}, and a continuous variable, \var{Y}, conditional on other variables,
\var{Z}.  The basic approach involves fitting an ordinal model of \var{X} on
\var{Z}, a linear model of \var{Y} on \var{Z}, and then determining whether there is any
residual information between \var{X} and \var{Y}.  This is done by
computing residuals for both models, calculating their correlation, and
testing the null of no residual correlation.  This procedure is analogous to test statistic
\code{T2} in \code{cobot}.  Two test statistics (correlations) are currently output.  The first
is the correlation between probability-scale residuals. The second is the correlation between
the observed-minus-expected residual for the continuous outcome model and a latent variable residual
for the ordinal model.
}
\details{
Formula is specified as \code{\var{X} | \var{Y} ~ \var{Z}}.
This indicates that models of \code{\var{X} ~ \var{Z}} and
\code{\var{Y} ~ \var{Z}} will be fit.  The null hypothsis to be
tested is \eqn{H_0 : X}{H0 : X} independant of \var{Y} conditional
on \var{Z}.  The ordinal variable, \code{\var{X}}, must precede the \code{|} and be a factor variable, and \code{\var{Y}} must be continuous.
}
\examples{
data(PResidData)
cocobot(y|w ~ z, data=PResidData)
}
\references{
Li C and Shepherd BE (2012)
A new residual for ordinal outcomes.
\emph{Biometrika}. \bold{99}: 473--480.

Shepherd BE, Li C, Liu Q (submitted)
Probability-scale residuals for continuous, discrete, and censored data.
}

