% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppsfs.R, R/ppsfsi.R
\name{PPS-method}
\alias{PPS-method}
\alias{ppsfs}
\alias{ppsfsi}
\title{Partial Profile Score Feature Selection for GLMs}
\usage{
ppsfs(
  x,
  y,
  family,
  keep = NULL,
  I0 = NULL,
  ...,
  ebicFlag = 1,
  maxK = min(NROW(x) - 1, NCOL(x) + length(I0)),
  verbose = FALSE
)

ppsfsi(
  x,
  y,
  family,
  keep = NULL,
  ...,
  ebicFlag = 1,
  maxK = min(NROW(x) - 1, choose(NCOL(x), 2)),
  verbose = FALSE
)
}
\arguments{
\item{x}{Matrix.}

\item{y}{Vector.}

\item{family}{See \link{glm} and \link{family}.}

\item{keep}{Initial set of features that are included in model fitting.}

\item{I0}{Index set of interaction effects to be identified.}

\item{...}{Additional parameters for \link{glm.fit}.}

\item{ebicFlag}{The procedure stops when the EBIC increases after \code{ebicFlag} times.}

\item{maxK}{Maximum number of identified features.}

\item{verbose}{Print the procedure path?}
}
\value{
Index set of identified features.
}
\description{
\code{ppsfs}: PPSFS for \strong{main-effects}.

\code{ppsfsi}: PPSFS for \strong{interaction effects}.
}
\details{
That \code{ppsfs(x, y, family="gaussian")} is an implementation to
\emph{sequential lasso} method proposed by Luo and Chen \doi{10/f6kfr6}.
}
\examples{
## ***************************************************
## Identify main-effect features
## ***************************************************
set.seed(2022)
n <- 300
p <- 1000
x <- matrix(rnorm(n*p), n)
eta <- drop( x[, 1:3] \%*\% runif(3, 1.0, 1.5) )
y <- eta + rnorm(n, sd=sd(eta)/5)
print( A <- ppsfs(x, y, 'gaussian', verbose=TRUE) )

## ***************************************************
## Identify interaction effects
## ***************************************************
set.seed(2022)
n <- 300
p <- 150
x <- matrix(rnorm(n*p), n)
eta <- drop( cbind(x[, 1:3], x[, 4:6]*x[, 7:9]) \%*\% runif(6, 1.0, 1.5) )
y <- eta + rnorm(n, sd=sd(eta)/5)
print( group <- ppsfsi(x, y, 'gaussian', verbose=TRUE) )
print( A <- ppsfs(x, y, "gaussian", I0=group, verbose=TRUE) )

print( A <- ppsfs(x, y, "gaussian", keep=c(1, "5:8"), 
                  I0=group, verbose=TRUE) )

}
\references{
Z. Xu, S. Luo and Z. Chen (2022). Partial profile score feature selection in
high-dimensional generalized linear interaction models. Statistics and Its Interface.
\doi{10.4310/21-SII706}
}
