% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns_labeller.R
\name{pns_labeller}
\alias{pns_labeller}
\title{Label categorical variables from PNS microdata}
\usage{
pns_labeller(data_pns, dictionary.file)
}
\arguments{
\item{data_pns}{A tibble of PNS microdata read with \code{read_pns} function.}

\item{dictionary.file}{The dictionary file for selected survey available on official website: (select the dictionary and input zip file, according to the appropriated year, microdata folder and then, inside, documentation) - \url{https://ftp.ibge.gov.br/PNS/}.}
}
\value{
A tibble with the data provided from PNS survey and its categorical variables as factors with related labels.
}
\description{
This function labels categorical variables from PNS microdata.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
input_path <- pns_example(path="input_example.txt")
data_path <- pns_example(path="exampledata.txt")
dictionary.path <- pns_example(path="dictionaryexample.xls")
pns.df <- read_pns(microdata=data_path, input_txt=input_path, vars=c("J007","J009"))
pns.df <- pns_labeller(data_pns=pns.df, dictionary.file=dictionary.path)
\donttest{
# Downloading data
pns.df2 <- get_pns(year=2019, selected=FALSE, anthropometry=FALSE, vars=c("J007","J009"),
                       labels=FALSE, deflator=FALSE, design=FALSE, reload=TRUE, savedir=tempdir())
dictionary.path2 <- pns_example(path="dictionaryexample.xls")
pns.df2 <- pns_labeller(data_pns=pns.df2, dictionary.file=dictionary.path2)}
}
\seealso{
\link[PNSIBGE]{get_pns} for downloading, labeling, deflating and creating survey design object for PNS microdata.\cr \link[PNSIBGE]{read_pns} for reading PNS microdata.\cr \link[PNSIBGE]{pns_deflator} for adding deflator variables to PNS microdata.\cr \link[PNSIBGE]{pns_design} for creating PNS survey design object.\cr \link[PNSIBGE]{pns_example} for getting the path of the PNS toy example files.
}
