% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_intensity.R
\name{get_intensity}
\alias{get_intensity}
\title{Classify activity intensity}
\usage{
get_intensity(mets, posture = NULL, ...)
}
\arguments{
\item{mets}{numeric vector of metabolic equivalents to classify}

\item{posture}{character vector of postures}

\item{...}{further arguments passed to \code{cut}}
}
\value{
a factor giving intensity classifications for each element of
  \code{mets}
}
\description{
Supports intensity classification via energy expenditure with or without
additional posture requirements (i.e., for sedentary behavior to be in
lying/seated posture)
}
\details{
If \code{breaks} and \code{labels} arguments are not provided, default values
are <= 1.5 METs for sedentary behavior, 1.51-2.99 METs for light physical
activity, and >= 3.0 METs for moderate-to-vigorous physical activity.

It is expected for the elements of \code{posture} to be one of \code{c("lie",
"sit", "stand", "other")}. The function will run (with a warning) if that
requirement is not met, but the output will likely be incorrect.
}
\examples{
mets <- seq(1, 8, 0.2)
posture <- rep(
c("lie", "sit", "stand", "other"), 9
)

intensity_no_posture <- get_intensity(mets)
intensity_posture <- get_intensity(mets, posture)
head(intensity_no_posture)
head(intensity_posture)

}
