% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.plot.R
\name{diagnostic.plot}
\alias{diagnostic.plot}
\alias{diagnostic.plot.default}
\alias{diagnostic.plot.resid}
\alias{diagnostic.plot.PAsso}
\alias{diagnostic.plot.glm}
\alias{diagnostic.plot.clm}
\alias{diagnostic.plot.lrm}
\alias{diagnostic.plot.orm}
\alias{diagnostic.plot.polr}
\title{Residual-based diagnostic plots}
\usage{
diagnostic.plot(object, ...)

\method{diagnostic.plot}{default}(object, ...)

\method{diagnostic.plot}{resid}(object, output = c("qq", "fitted", "covariate"), ...)

\method{diagnostic.plot}{PAsso}(
  object,
  output = c("qq", "fitted", "covariate"),
  model_id = NULL,
  x_name = NULL,
  ...
)

\method{diagnostic.plot}{glm}(
  object,
  output = c("qq", "fitted", "covariate"),
  x = NULL,
  fit = NULL,
  distribution = qnorm,
  ncol = NULL,
  alpha = 1,
  xlab = NULL,
  color = "#444444",
  shape = 19,
  size = 2,
  qqpoint.color = "#444444",
  qqpoint.shape = 19,
  qqpoint.size = 2,
  qqline.color = "#888888",
  qqline.linetype = "dashed",
  qqline.size = 1,
  smooth = TRUE,
  smooth.color = "red",
  smooth.linetype = 1,
  smooth.size = 1,
  fill = NULL,
  resp_name = NULL,
  ...
)

\method{diagnostic.plot}{clm}(object, output = c("qq", "fitted", "covariate"), ...)

\method{diagnostic.plot}{lrm}(object, output = c("qq", "fitted", "covariate"), ...)

\method{diagnostic.plot}{orm}(object, output = c("qq", "fitted", "covariate"), ...)

\method{diagnostic.plot}{polr}(object, output = c("qq", "fitted", "covariate"), ...)
}
\arguments{
\item{object}{The object in the support classes (This function is mainly designed
for \code{PAsso}).}

\item{...}{Additional optional arguments can be passed onto \code{\link[ggplot2]{ggplot}} for drawing
various plots.}

\item{output}{A character string specifying what type of output to plot. Default is
\code{"qq"} which produces a plot matrix with quantile-quantile plots of the residuals.
\code{"fitted"} produces a plot matrix between residuals and all corresponding fitted responses.
\code{"covariates"} produces a plot matrix between residuals and corresponding covariate.}

\item{model_id}{A number refers to the index of the model that needs to be diagnosed. If NULL, all
models will be diagnosed.}

\item{x_name}{A string refers to the covariate name that needs to be diagnosed. If NULL, all adjustments
will be diagnosed.}

\item{x}{A vector giving the covariate values to use for residual-by-
covariate plots (i.e., when \code{output = "covariate"}).}

\item{fit}{The fitted model from which the residuals were extracted. (Only
required if \code{output = "fitted"} and \code{object} inherits from class
\code{"resid"}.)}

\item{distribution}{Function that computes the quantiles for the reference
distribution to use in the quantile-quantile plot. Default is \code{qnorm}
which is only appropriate for models using a probit link function. When
\code{jitter.scale = "probability"}, the reference distribution is always
U(-0.5, 0.5). (Only
required if \code{object} inherits from class \code{"resid"}.)}

\item{ncol}{Integer specifying the number of columns to use for the plot
layout (if requesting multiple plots). Default is \code{NULL}.}

\item{alpha}{A single values in the interval [0, 1] controlling the opacity
alpha of the plotted points. Only used when \code{nsim} > 1.}

\item{xlab}{Character string giving the text to use for the x-axis label in
residual-by-covariate plots. Default is \code{NULL}.}

\item{color}{Character string or integer specifying what color to use for the
points in the residual vs fitted value/covariate plot.
Default is \code{"black"}.}

\item{shape}{Integer or single character specifying a symbol to be used for
plotting the points in the residual vs fitted value/covariate plot.}

\item{size}{Numeric value specifying the size to use for the points in the
residual vs fitted value/covariate plot.}

\item{qqpoint.color}{Character string or integer specifying what color to use
for the points in the quantile-quantile plot.}

\item{qqpoint.shape}{Integer or single character specifying a symbol to be
used for plotting the points in the quantile-quantile plot.}

\item{qqpoint.size}{Numeric value specifying the size to use for the points
in the quantile-quantile plot.}

\item{qqline.color}{Character string or integer specifying what color to use
for the points in the quantile-quantile plot.}

\item{qqline.linetype}{Integer or character string (e.g., \code{"dashed"})
specifying the type of line to use in the quantile-quantile plot.}

\item{qqline.size}{Numeric value specifying the thickness of the line in the
quantile-quantile plot.}

\item{smooth}{Logical indicating whether or not too add a nonparametric
smooth to certain plots. Default is \code{TRUE}.}

\item{smooth.color}{Character string or integer specifying what color to use
for the nonparametric smooth.}

\item{smooth.linetype}{Integer or character string (e.g., \code{"dashed"})
specifying the type of line to use for the nonparametric smooth.}

\item{smooth.size}{Numeric value specifying the thickness of the line for the
nonparametric smooth.}

\item{fill}{Character string or integer specifying the color to use to fill
the boxplots for residual-by-covariate plots when \code{x} is of class
\code{"factor"}. Default is \code{NULL} which colors the boxplots according
to the factor levels.}

\item{resp_name}{Character string to specify the response name that will be
displayed in the figure.}
}
\value{
A \code{"ggplot"} object for supported models. For class "PAsso", it returns a plot in
\code{"gtable"} object that combines diagnostic plots of all responses.

A "ggplot" object based on the input residuals.

A "ggplot" object based on the input residuals.

A plot in "gtable" object that combines diagnostic plots of all responses.

A "ggplot" object based on the residuals generated from glm object.

A "ggplot" object based on the residuals generated from clm object.

A "ggplot" object based on the residuals generated from lrm object.

A "ggplot" object based on the residuals generated from orm object.

A "ggplot" object based on the residuals generated from polr object.
}
\description{
A set of visualization tools for the diagnostic of the fitted model in
the partial association analysis. It can provides a plot matrix including Q-Q plots,
residual-vs-fitted plots, residual-vs-covariate plots of all the fitted models.
This function also support the direct diagnostic of the cumulative link regression model
in the class of \code{\link[ordinal]{clm}}, \code{\link[stats]{glm}}, \code{\link[rms]{lrm}},
\code{\link[rms]{orm}}, \code{\link[MASS]{polr}}. Currently, \code{\link[VGAM]{vglm}}
is not supported.
}
\examples{
# Import data for partial association analysis
data("ANES2016")
ANES2016$PreVote.num <- as.factor(ANES2016$PreVote.num)

PAsso_3v <- PAsso(responses = c("PreVote.num", "PID", "selfLR"),
                  adjustments = c("income.num", "age", "edu.year"),
                  data = ANES2016, uni.model = "probit",
                  method = c("kendall"),
                  resids.type = "surrogate", jitter = "latent")

diag_p1 <- diagnostic.plot(object = PAsso_3v, output = "qq")
diag_p2 <- diagnostic.plot(object = PAsso_3v, output = "fitted")
diag_p3 <- diagnostic.plot(object = PAsso_3v, output = "covariate")

# Simply diagnose a model
# Fit cumulative link models

fit1 <- ordinal::clm(PreVote.num ~ income.num + age + edu.year, data = ANES2016, link = "logit")

# diagnostic.plot
plot_qq_1 <- diagnostic.plot(object = fit1, output = "qq")
plot_fit_1 <- diagnostic.plot(object = fit1, output = "fitted")
plot_cov_1 <- diagnostic.plot(object = fit1, output = "covariate")

}
