% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Joint_gaussian.R
\name{Joint_Gaussian}
\alias{Joint_Gaussian}
\title{Estimation of network structure and variable selection in the linear model via the Gaussian maximum likelihood.}
\usage{
Joint_Gaussian(
  W,
  Z,
  sigma_eta,
  sigma_delta,
  alpha_1,
  alpha_2,
  alpha_1_list = NULL,
  alpha_2_list = NULL,
  label_name = TRUE
)
}
\arguments{
\item{W}{A n × m response matrix, the variables can be error-prone or precisely measured.}

\item{Z}{A n × p matrix of continuous covariates. The variables can be error-prone or precisely measured.}

\item{sigma_eta}{A p × p covariance matrix of the noise term \eqn{\eta} in the classical measurement error model Z = X + \eqn{\eta}, where X is the unobserved version of Z.}

\item{sigma_delta}{A m × m covariance matrix of the noise term \eqn{\delta} in the classical measurement error model W = Y + \eqn{\delta}, where Y is the unobserved version of W.}

\item{alpha_1}{A tuning parameter associated with the parameter B.}

\item{alpha_2}{A tuning parameter associated with precision matrix C, which is the inverse of the covariance matrix of \eqn{\epsilon}.}

\item{alpha_1_list}{A list of tuning parameters for the model averaging estimator of B. The default value is NULL.}

\item{alpha_2_list}{A list of tuning parameters for the model averaging estimator of C. The default value is NULL.}

\item{label_name}{The name of the response variable. The default value is TRUE, which reflects the labels from the input data. Else, users can input the required labels manually.}
}
\value{
\item{B}{An estimator of B.}
  \item{C}{An estimator of C.}
  \item{graph}{A visualization of the estimated network structure by C.}
  \item{Beta_BICs}{A vector of Bayesian Information Criterion (BIC) weights for the model averaging estimator of B under candidate models alpha_1_list.}
  \item{Gamma_BICs}{A vector of Bayesian Information Criterion (BIC) weights for the model averaging estimator of C under candidate models alpha_2_list.}
}
\description{
This function focuses on multivariate linear regression models Y = XB + \eqn{\epsilon} subject to measurement error in the responses and covariates, where with B is a matrix of parameters and \eqn{\epsilon} is a noise term with zero expectation. We aim to detect the network structure of responses and select informative covaraites. The estimation method is motivated by the Gaussian maximum likelihood function and uses the conditional expectation to correct for measurement error.
}
\examples{
n <- 100
Z <- matrix(rnorm(n * 10), n, 10)
W <- matrix(rnorm(n * 5), n, 5)
sigma_eta <- diag(0.15, ncol(Z))
sigma_delta <- diag(0.3, ncol(W))

Joint_Gaussian(W, Z, sigma_eta, sigma_delta,
                         alpha_1 = 0.1, alpha_2 = 0.1,
                         alpha_1_list = c(0.1, 0.3),
                         alpha_2_list = c(0.1, 0.3),
                         label_name = TRUE)

}
\author{
Wan-Yi Chang and Li-Pang Chen \cr
Maintainer: Wan-Yi Chang \email{jessica306a@gmail.com}
}
