% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opm.R
\name{quantile.opm}
\alias{quantile.opm}
\title{Posterior Sample Quantiles}
\usage{
\method{quantile}{opm}(x, parm, ...)
}
\arguments{
\item{x}{an instance of class \code{opm} whose sample quantiles are
wanted}

\item{parm}{a specification of which parameters are to be given
       quantiles, either a vector of names ("\code{rho}", "\code{sig2}",
and "\code{beta}" are the only legal values) or a vector of positional
indices. If missing, all parameters are considered.}

\item{...}{further arguments passed to the \code{\link{quantile}}
function operating on the individual parameter's samples}
}
\value{
A matrix of quantiles for each of the desired parameters,
with parameters arranged in columns. If arguments include
"\code{names = FALSE}", the quantile labels won't be included
(i.e., the rownames of the matrix will be \code{NULL}).
}
\description{
Produces quantiles of the posterior samples corresponding to the
given probabilities. In other words, it is equivalent to computing
"\code{quantile(x, ...)}", where "\code{x}" is the original Monte
Carlo sample of the parameter "\code{parm}", as produced by
\code{\link{opm}}.
}
\seealso{
\code{\link{quantile}}
}

