% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OralOpioids.R
\name{MED}
\alias{MED}
\title{Get the Morphine Equivalent Dose (MED) from Health Canada by using the DIN}
\usage{
MED(Drug_ID, HealthCanada_Opioid_Table)
}
\arguments{
\item{Drug_ID}{A numeric value for the DIN. Exclude all zeros in front}

\item{HealthCanada_Opioid_Table}{Health Canada opioid dataset which can be loaded by using
the \code{load_HealthCanada_Opioid_Table()} function. Please run \code{load_HealthCanada_Opioid_Table()} function. The name you use to call the function should be input here.}
}
\value{
MED: Morphine Equivalent Dose
}
\description{
\code{MED} retrieves the Morphine Equivalent Dose from the HealthCanada_Opioid_Table.
}
\examples{

HealthCanada_Opioid_Table <- load_HealthCanada_Opioid_Table(no_download = TRUE)
MED(786535, HealthCanada_Opioid_Table)
}
