% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_spec.R
\name{write_spec}
\alias{write_spec}
\alias{write_spec.default}
\alias{write_spec.OpenSpecy}
\alias{read_spec}
\alias{as_hyperSpec}
\title{Read and write spectral data}
\usage{
write_spec(x, ...)

\method{write_spec}{default}(x, ...)

\method{write_spec}{OpenSpecy}(x, file, method = NULL, digits = getOption("digits"), ...)

read_spec(file, share = NULL, method = NULL, ...)

as_hyperSpec(x)
}
\arguments{
\item{x}{an object of class \code{\link{OpenSpecy}}.}

\item{file}{file path to be read from or written to.}

\item{method}{optional; function to be used as a custom reader or writer.
Defaults to the appropriate function based on the file extension.}

\item{digits}{number of significant digits to use when formatting numeric
values; defaults to \code{\link[base]{getOption}("digits")}.}

\item{share}{defaults to \code{NULL}; needed to share spectra with the
Open Specy community; see \code{\link{share_spec}()} for details.}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
\code{read_spec()} reads data formatted as an \code{OpenSpecy} object and
returns a list object of class \code{\link{OpenSpecy}} containing spectral
data.
\code{write_spec()} writes a file for an object of class
\code{\link{OpenSpecy}} containing spectral data.
\code{as_hyperspec()} converts an \code{OpenSpecy} object to a
\code{\link[hyperSpec]{hyperSpec-class}} object.
}
\description{
Functions for reading and writing spectral data to and from OpenSpecy format.
\code{OpenSpecy} objects are lists with components \code{wavenumber}, \code{spectra},
and \code{metadata}. Currently supported formats are .y(a)ml, .json, .csv, or .rds.
}
\details{
Due to floating point number errors there may be some differences in the
precision of the numbers returned if using multiple devices for .json and
.yaml files but the numbers should be nearly identical.
\code{\link[base]{readRDS}()} should return the exact same object every time.
}
\examples{
read_extdata("raman_hdpe.yml") |> read_spec()
read_extdata("raman_hdpe.json") |> read_spec()
read_extdata("raman_hdpe.rds") |> read_spec()
read_extdata("raman_hdpe.csv") |> read_spec()

\dontrun{
data(raman_hdpe)
write_spec(raman_hdpe, "raman_hdpe.yml")
write_spec(raman_hdpe, "raman_hdpe.json")
write_spec(raman_hdpe, "raman_hdpe.rds")
write_spec(raman_hdpe, "raman_hdpe.csv")

# Convert an OpenSpecy object to a hyperSpec object
hyper <- as_hyperSpec(raman_hdpe)
}

}
\seealso{
\code{\link{OpenSpecy}()};
\code{\link{read_text}()}, \code{\link{read_asp}()}, \code{\link{read_spa}()},
\code{\link{read_spc}()}, and \code{\link{read_jdx}()} for text files, .asp,
.spa, .spa, .spc, and .jdx formats, respectively;
\code{\link{read_zip}()} and \code{\link{read_any}()} for wrapper functions;
\code{\link[base]{saveRDS}()}; \code{\link[base]{readRDS}()};
\code{\link[yaml]{write_yaml}()}; \code{\link[yaml]{read_yaml}()};
\code{\link[jsonlite]{write_json}()}; \code{\link[jsonlite]{read_json}()};
}
\author{
Zacharias Steinmetz, Win Cowger
}
