% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensityAnalysis.R
\name{intensityAnalysis}
\alias{intensityAnalysis}
\title{Performs the intensity analysis based on cross-tabulation matrices of each
time step}
\usage{
intensityAnalysis(dataset, category_n, category_m, area_km2 = TRUE)
}
\arguments{
\item{dataset}{list. The result object from \code{\link{contingencyTable}}.}

\item{category_n}{character. The gaining category in the transition of interest (\emph{n}).}

\item{category_m}{character. The losing category in the transition of interest (\emph{m}).}

\item{area_km2}{logical. If TRUE the change is computed in km2, if FALSE in pixel counts.}
}
\value{
Intensity object
}
\description{
This function implements an Intensity Analysis (IA) according to Aldwaik &
Pontius (2012), a quantitative method to analyze time series of land use and
cover (LUC) maps.  For IA, a cross-tabulation matrix is composed for each LUC
transition step in time.
}
\details{
IA includes three levels of analysis of LUC changes. Consecutive analysis
levels detail hereby information given by the previous analysis level
\cite{(Aldwaik and Pontius, 2012, 2013)}.


\enumerate{
 \item The \emph{interval level} examines how the size and speed of change
 vary across time intervals.
 \item The \emph{category level} examines how the size and intensity of gross
 losses and gross gains in each category vary across categories for each time
 interval.
 \item The \emph{transition level} examines how the size and intensity of a
 category’s transitions vary across the other categories that are available
 for that transition.
  }


At each analysis level, the method tests for stationarity of patterns across
time intervals.

\bold{The function returns a list with 6 objects:}
\enumerate{
 \item lulc_table: \code{tibble}. Contingency table of LUC transitions at all
  analysed time steps, containing 6 columns:
   \enumerate{
   \item Period:  \code{<fct>}. Evaluated period of transition in the format
   \code{year t - year t+1}.
   \item From: \code{<fct>}. The category in year t.
   \item To: \code{<fct>}. The category in year t+1.
   \item km2: \code{<dbl>}. Area in square kilometers that transited from the
    category \code{From}.
   to the category \code{To} in the period.
   \item QtPixel: \code{<int>}. Number of pixels that transited from.
   the category \code{From} to the category \code{To} in the period.
   \item Interval: \code{<int>}. Interval in years of the evaluated period.

   }

 \item \emph{lv1_tbl}: An \code{\linkS4class{Interval}} object containing the
  \emph{St} and \emph{U} values.
 \item \emph{category_lvlGain}: A \code{\linkS4class{Category}} object
 containing the gain of the LUC category in a period (\emph{Gtj}).
 \item \emph{category_lvlLoss}: A \code{\linkS4class{Category}} object
 containing the loss of the LUC category in a period (\emph{Lti}).
 \item \emph{transition_lvlGain_n}: A \code{\linkS4class{Transition}} object
 containing the annualized rate of gain in \emph{category n} (\emph{Rtin}) and
 the respective Uniform Intensity (\emph{Wtn}).
 \item \emph{transition_lvlLoss_m}: A \code{\linkS4class{Transition}} object
 containing the annualized rate of loss in \emph{category m} (\emph{Qtmj}) and
 the respective Uniform Intensity (\emph{Vtm}).

  }
}
\examples{

# editing the category name

SL_2002_2014$tb_legend$categoryName <- factor(c("Ap", "FF", "SA", "SG", "aa", "SF",
                                             "Agua", "Iu", "Ac", "R", "Im"),
                                  levels = c("FF", "SF", "SA", "SG", "aa", "Ap",
                                             "Ac", "Im", "Iu", "Agua", "R"))

SL_2002_2014$tb_legend$color <- c("#FFE4B5", "#228B22", "#00FF00", "#CAFF70",
                                  "#EE6363", "#00CD00", "#436EEE", "#FFAEB9",
                                  "#FFA54F", "#68228B", "#636363")

intensityAnalysis(dataset = SL_2002_2014, category_n = "Ap", category_m = "SG", area_km2 = TRUE)


}
\references{
Aldwaik, S. Z. and Pontius, R. G. (2012) ‘Intensity analysis to unify
measurements of size and stationarity of land changes by interval, category, and
transition, Landscape and Urban Planning. Elsevier B.V., 106(1), pp. 103–114.
\doi{10.1016/j.landurbplan.2012.02.010}.

Aldwaik, S. Z. and Pontius, R. G. (2013) ‘Map errors that could account for deviations
from a uniform intensity of land change, International Journal of Geographical
Information Science. Taylor & Francis, 27(9), pp. 1717–1739. \doi{10.1080/13658816.2013.787618}.
}
