% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_qc_plot.R
\name{olink_qc_plot}
\alias{olink_qc_plot}
\title{Function to plot an overview of a sample cohort per Panel}
\usage{
olink_qc_plot(
  df,
  color_g = "QC_Warning",
  plot_index = FALSE,
  label_outliers = TRUE,
  IQR_outlierDef = 3,
  median_outlierDef = 3,
  outlierLines = TRUE,
  facetNrow = NULL,
  facetNcol = NULL,
  ...
)
}
\arguments{
\item{df}{NPX data frame in long format. Must have columns SampleID, NPX and Panel}

\item{color_g}{Character value indicating which column to use as fill color (default QC_Warning)}

\item{plot_index}{Boolean. If FALSE (default), a point will be plotted for a sample. If TRUE,
a sample's unique index number is displayed.}

\item{label_outliers}{Boolean. If TRUE, an outlier sample will be labelled with its SampleID.}

\item{IQR_outlierDef}{The number of standard deviations from the mean IQR that defines an outlier (default 3)}

\item{median_outlierDef}{The number of standard deviations from the mean sample median that defines an outlier. (default 3)}

\item{outlierLines}{Draw dashed lines at +/-IQR_outlierDef and +/-median_outlierDef standard deviations from the mean IQR and sample median respectively (default TRUE)}

\item{facetNrow}{The number of rows that the panels are arranged on}

\item{facetNcol}{The number of columns that the panels are arranged on}

\item{...}{coloroption passed to specify color order}
}
\value{
An object of class "ggplot". Scatterplot shows IQR vs median for all samples per panel
}
\description{
Generates a facet plot per Panel using ggplot2::ggplot and ggplot2::geom_point and stats::IQR plotting IQR vs. median for all samples.
Horizontal dashed lines indicate +/-IQR_outlierDef standard deviations from the mean IQR (default 3).
Vertical dashed lines indicate +/-median_outlierDef standard deviations from the mean sample median (default 3).
}
\examples{
\donttest{
library(dplyr)

olink_qc_plot(npx_data1, color_g = "QC_Warning")

#Change the outlier threshold to +-4SD
olink_qc_plot(npx_data1, color_g = "QC_Warning", IQR_outlierDef = 4, median_outlierDef = 4)

#Identify the outliers
qc <- olink_qc_plot(npx_data1, color_g = "QC_Warning", IQR_outlierDef = 4, median_outlierDef = 4)
outliers <- qc$data \%>\% filter(Outlier == 1)
}
}
\keyword{NPX}
