% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{RCE}
\alias{RCE}
\title{A function to compute Relatice Centralisation Index (RCE)}
\usage{
RCE(x, dc = NULL, center = 1, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{dc}{- a vector with distances from the spatial units cetroids
to the center}

\item{center}{- a value giving the number of the spatial unit
that represents the zones's center}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A matrix with Relative Centralisation index
}
\description{
Relative Centralisation Index measures the proportion
of a group that should change localisation to obtain the same level
of centralisation that another group. The function can be used
in two ways: by providing a vector with the distances to the center
or a geographic source (spatial object or shape file) wich will be
used to compute the vector within the function. The center parameter
is necessary to specify the number of the spatial unit representing
the center.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
distc<- distcenter(GreHSize, center = 19)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

RCE(x, dc=distc)

RCE(x, spatobj = GreHSize, center = 19)

RCE(x, folder = foldername, shape = shapename, center = 19)
}
\references{
Duncan O. D. and Duncan B. (1955) \emph{A
Methodological Analysis of Segregation Indexes}.
American Sociological Review 41, pp. 210-217
}
\seealso{
Absolute Centralisation Index: \code{\link{ACE}}
}

