% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtLogits.R
\name{MvtLogis}
\alias{MvtLogis}
\alias{dmvlogis}
\alias{pmvlogis}
\alias{qmvlogis}
\alias{rmvlogis}
\alias{smvlogis}
\title{Multivariate Logistic Distribution}
\usage{
dmvlogis(x, parm1 = rep(1, k), parm2 = rep(1, k), log = FALSE)

pmvlogis(q, parm1 = rep(1, k), parm2 = rep(1, k))

qmvlogis(p, parm1 = rep(1, k), parm2 = rep(1, k), interval = c(0,
  1e+08))

rmvlogis(n, parm1 = rep(1, k), parm2 = rep(1, k))

smvlogis(q, parm1 = rep(1, k), parm2 = rep(1, k))
}
\arguments{
\item{x}{vector or matrix of quantiles. If x is a matrix, each row vector constitutes a vector of quantiles for which the density f(x) is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm1}{a vector of location parameters, see parameter \eqn{\mu_i} in \strong{Details}.}

\item{parm2}{a vector of scale parameters, see parameters \eqn{\sigma_i} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities f are given as log(f).}

\item{q}{a vector of quantiles.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(0, 1e8)}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvlogis} gives the numerical values of the probability density.

\code{pmvlogis} gives the cumulative probability.

\code{qmvlogis} gives the equicoordinate quantile.

\code{rmvlogis} generates random numbers.

\code{smvlogis} gives the value of survival function
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for multivariate logistic distribution with vector parameter \code{parm1} and vector parameter \code{parm2}.
}
\details{
Bivariate logistic distribution was introduced by Gumbel (1961) and its multivariate generalization was given by Malik and Abraham (1973) as
\deqn{f(x_1, \cdots, x_k) = \frac{k! \exp{(-\sum_{i=1}^{k} \frac{x_i - \mu_i}{\sigma_i})}}{[\prod_{i=1}^{p} \sigma_i] [1 + \sum_{i=1}^{k} \exp{(-\frac{x_i - \mu_i}{\sigma_i})}]^{1+k}},}
where \eqn{-\infty<x_i, \mu_i<\infty, \sigma_i > 0, i=1,\cdots, k}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is given as
\deqn{F(x_1, \cdots, x_k) = \left[1 + \sum_{i=1}^{k} \exp(-\frac{x_i-\mu_i}{\sigma_i})\right]^{-1}.}

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{-\infty}^{q} \cdots \int_{-\infty}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

The survival function \eqn{\bar{F}(x_1, \cdots, x_k)} is obtained by the following formula related to cumulative distribution function \eqn{F(x_1, \dots, x_k)} (Joe, 1997)
\deqn{\bar{F}(x_1, \cdots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} F_S(x_j, j \in S).}

Random numbers \eqn{X_1, \cdots, X_k} from multivariate logistic distribution can be generated through transformation of multivariate Lomax random variables \eqn{Y_1, \cdots, Y_k} by letting \eqn{X_i=\mu_i-\sigma_i\ln(\theta_i Y_i), i = 1, \cdots, k}; see Nayak (1987).
}
\examples{
# Calculations for the multivariate logistic distribution with parameters:
# mu1 = 0.5, mu2 = 1, mu3 = 2, sigma1 = 1, sigma2 = 2 and sigma3 = 3
# Vector of quantiles: c(3, 2, 1)

dmvlogis(x = c(3, 2, 1), parm1 = c(0.5, 1, 2), parm2 = c(1, 2, 3)) # Density

pmvlogis(q = c(3, 2, 1), parm1 = c(0.5, 1, 2), parm2 = c(1, 2, 3)) # Cumulative Probability

# Equicoordinate quantile of cumulative probability 0.5
qmvlogis(p = 0.5, parm1 = c(0.5, 1, 2), parm2 = c(1, 2, 3))

# Random numbers generation with sample size 100
rmvlogis(n = 100, parm1 = c(0.5, 1, 2), parm2 = c(1, 2, 3)) 

smvlogis(q = c(3, 2, 1), parm1 = c(0.5, 1, 2), parm2 = c(1, 2, 3)) # Survival function

}
\references{
Gumbel, E.J. (1961). Bivariate logistic distribution. \emph{J. Am. Stat. Assoc.}, 56, 335-349.

Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Malik, H. J. and Abraham, B. (1973). Multivariate logistic distributions. \emph{Ann. Statist.} 3, 588-590.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
